#ifndef _WMM_DATA_H
#define _WMM_DATA_H

#include "wmm.h"

#define START_YEAR 2020
#define END_YEAR 2025

#define MAXL 12
#define MAXENTRY ((MAXL+2)*(MAXL+1)/2-1)

typedef struct {
	int n;
	int m;
	WMM_REAL g;
	WMM_REAL h;
	WMM_REAL gder;
	WMM_REAL hder;
	} WMM_ENTRY;

//WMM data from NOAA follow here
//they can be generated from the official WMM.COF file by the following script
//tail -n +2 bin/WMM.COF | grep -v 9999999999999 | awk '{printf("{%d,%d,%f,%f,%f,%f},\n",$1,$2,$3,$4,$5,$6);}'

const WMM_ENTRY wmmdata[MAXENTRY] = {
{1,0,-29404.500000,0.000000,6.700000,0.000000},
{1,1,-1450.700000,4652.900000,7.700000,-25.100000},
{2,0,-2500.000000,0.000000,-11.500000,0.000000},
{2,1,2982.000000,-2991.600000,-7.100000,-30.200000},
{2,2,1676.800000,-734.800000,-2.200000,-23.900000},
{3,0,1363.900000,0.000000,2.800000,0.000000},
{3,1,-2381.000000,-82.200000,-6.200000,5.700000},
{3,2,1236.200000,241.800000,3.400000,-1.000000},
{3,3,525.700000,-542.900000,-12.200000,1.100000},
{4,0,903.100000,0.000000,-1.100000,0.000000},
{4,1,809.400000,282.000000,-1.600000,0.200000},
{4,2,86.200000,-158.400000,-6.000000,6.900000},
{4,3,-309.400000,199.800000,5.400000,3.700000},
{4,4,47.900000,-350.100000,-5.500000,-5.600000},
{5,0,-234.400000,0.000000,-0.300000,0.000000},
{5,1,363.100000,47.700000,0.600000,0.100000},
{5,2,187.800000,208.400000,-0.700000,2.500000},
{5,3,-140.700000,-121.300000,0.100000,-0.900000},
{5,4,-151.200000,32.200000,1.200000,3.000000},
{5,5,13.700000,99.100000,1.000000,0.500000},
{6,0,65.900000,0.000000,-0.600000,0.000000},
{6,1,65.600000,-19.100000,-0.400000,0.100000},
{6,2,73.000000,25.000000,0.500000,-1.800000},
{6,3,-121.500000,52.700000,1.400000,-1.400000},
{6,4,-36.200000,-64.400000,-1.400000,0.900000},
{6,5,13.500000,9.000000,-0.000000,0.100000},
{6,6,-64.700000,68.100000,0.800000,1.000000},
{7,0,80.600000,0.000000,-0.100000,0.000000},
{7,1,-76.800000,-51.400000,-0.300000,0.500000},
{7,2,-8.300000,-16.800000,-0.100000,0.600000},
{7,3,56.500000,2.300000,0.700000,-0.700000},
{7,4,15.800000,23.500000,0.200000,-0.200000},
{7,5,6.400000,-2.200000,-0.500000,-1.200000},
{7,6,-7.200000,-27.200000,-0.800000,0.200000},
{7,7,9.800000,-1.900000,1.000000,0.300000},
{8,0,23.600000,0.000000,-0.100000,0.000000},
{8,1,9.800000,8.400000,0.100000,-0.300000},
{8,2,-17.500000,-15.300000,-0.100000,0.700000},
{8,3,-0.400000,12.800000,0.500000,-0.200000},
{8,4,-21.100000,-11.800000,-0.100000,0.500000},
{8,5,15.300000,14.900000,0.400000,-0.300000},
{8,6,13.700000,3.600000,0.500000,-0.500000},
{8,7,-16.500000,-6.900000,0.000000,0.400000},
{8,8,-0.300000,2.800000,0.400000,0.100000},
{9,0,5.000000,0.000000,-0.100000,0.000000},
{9,1,8.200000,-23.300000,-0.200000,-0.300000},
{9,2,2.900000,11.100000,-0.000000,0.200000},
{9,3,-1.400000,9.800000,0.400000,-0.400000},
{9,4,-1.100000,-5.100000,-0.300000,0.400000},
{9,5,-13.300000,-6.200000,-0.000000,0.100000},
{9,6,1.100000,7.800000,0.300000,-0.000000},
{9,7,8.900000,0.400000,-0.000000,-0.200000},
{9,8,-9.300000,-1.500000,-0.000000,0.500000},
{9,9,-11.900000,9.700000,-0.400000,0.200000},
{10,0,-1.900000,0.000000,0.000000,0.000000},
{10,1,-6.200000,3.400000,-0.000000,-0.000000},
{10,2,-0.100000,-0.200000,-0.000000,0.100000},
{10,3,1.700000,3.500000,0.200000,-0.300000},
{10,4,-0.900000,4.800000,-0.100000,0.100000},
{10,5,0.600000,-8.600000,-0.200000,-0.200000},
{10,6,-0.900000,-0.100000,-0.000000,0.100000},
{10,7,1.900000,-4.200000,-0.100000,-0.000000},
{10,8,1.400000,-3.400000,-0.200000,-0.100000},
{10,9,-2.400000,-0.100000,-0.100000,0.200000},
{10,10,-3.900000,-8.800000,-0.000000,-0.000000},
{11,0,3.000000,0.000000,-0.000000,0.000000},
{11,1,-1.400000,-0.000000,-0.100000,-0.000000},
{11,2,-2.500000,2.600000,-0.000000,0.100000},
{11,3,2.400000,-0.500000,0.000000,0.000000},
{11,4,-0.900000,-0.400000,-0.000000,0.200000},
{11,5,0.300000,0.600000,-0.100000,-0.000000},
{11,6,-0.700000,-0.200000,0.000000,0.000000},
{11,7,-0.100000,-1.700000,-0.000000,0.100000},
{11,8,1.400000,-1.600000,-0.100000,-0.000000},
{11,9,-0.600000,-3.000000,-0.100000,-0.100000},
{11,10,0.200000,-2.000000,-0.100000,0.000000},
{11,11,3.100000,-2.600000,-0.100000,-0.000000},
{12,0,-2.000000,0.000000,0.000000,0.000000},
{12,1,-0.100000,-1.200000,-0.000000,-0.000000},
{12,2,0.500000,0.500000,-0.000000,0.000000},
{12,3,1.300000,1.300000,0.000000,-0.100000},
{12,4,-1.200000,-1.800000,-0.000000,0.100000},
{12,5,0.700000,0.100000,-0.000000,-0.000000},
{12,6,0.300000,0.700000,0.000000,0.000000},
{12,7,0.500000,-0.100000,-0.000000,-0.000000},
{12,8,-0.200000,0.600000,0.000000,0.100000},
{12,9,-0.500000,0.200000,-0.000000,-0.000000},
{12,10,0.100000,-0.900000,-0.000000,-0.000000},
{12,11,-1.100000,-0.000000,-0.000000,0.000000},
{12,12,-0.300000,0.500000,-0.100000,-0.100000},
};

#endif

