#ifndef _keeloq1_h
#define _keeloq1_h

#include <stdint.h>
#include "keeloq.h"

//!!!little endian assumed to have the correct bit order

typedef struct
        {
	unsigned int counter :16 __attribute__((packed)) ;
	unsigned int discriminator :10 __attribute__((packed)) ;
	unsigned int ovr :2 __attribute__((packed)) ; //is not supported now
	unsigned int buttons :4 __attribute__((packed)) ;
	}
	PLAINTEXT;

typedef union
	{
	PLAINTEXT plaintext;
	uint32_t ciphertext;
	}
	HOPCODE;

typedef struct
        {
        unsigned long serial :28 __attribute__((packed)) ;
	unsigned int buttons :4 __attribute__((packed)) ;
        }
	FIXCODE; //ignore Vlow and Repeat bits

typedef struct
	{
	HOPCODE var;
	FIXCODE fix;
	}
	MESSAGE1;

typedef union
	{
	MESSAGE1 m;
	uint8_t c[8];
	}
	MESSAGE1UNION;


typedef struct
	{
	KEELOQ_CODE keeloq; //we do not use seed, rather KEELOQ_CODE is randomly generated
	uint32_t serial;
	uint16_t discriminator;
	uint16_t counter;
	}
	REMOTE_ENTRY; 

inline void encrypt1(register HOPCODE *code, KEELOQ_CODE *key)
	{
	encrypt(& code->ciphertext, key);
	}

inline void decrypt1(register HOPCODE *code, KEELOQ_CODE *key)
        {
        decrypt(& code->ciphertext, key);
        }

extern uint8_t process_message(uint8_t *buttons, uint8_t *serial, uint8_t *m, uint8_t n_remotes, REMOTE_ENTRY  *remotes, uint16_t *resyncs);

extern uint8_t generate_message(uint8_t *m0, uint8_t buttons, REMOTE_ENTRY *remote);

#endif
