/*
 * 	Copyright (C) 2006-2014 Jiri Pittner <jiri@pittnerovi.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 	                                         
 * 	                                        
*/

#ifndef _keeloq1_c
#define _keeloq1_c

#include "keeloq1.h"
#include "keeloq.c"


uint8_t generate_message(uint8_t *m0, uint8_t buttons, REMOTE_ENTRY *remote)
{
MESSAGE1 *m =  & ((MESSAGE1UNION *)m0)->m;
m->fix.buttons = buttons;
m->fix.serial = remote->serial;

m->var.plaintext.buttons = buttons;
m->var.plaintext.ovr=0;
m->var.plaintext.discriminator = remote->discriminator;
m->var.plaintext.counter = remote->counter++;

encrypt1(&m->var,&remote->keeloq);

m0[8]=1; //last bit
return 65;
}


uint8_t process_message(uint8_t *buttons, uint8_t *serial, uint8_t *m0, uint8_t n_remotes, REMOTE_ENTRY  *remotes, uint16_t *resync)
{
uint8_t i,n;
MESSAGE1 *m =  & ((MESSAGE1UNION *)m0)->m;
for(i=0; i<n_remotes; ++i) if(m->fix.serial == remotes[i].serial) goto remote_found;
#ifdef debug
printP(PSTR("remote not on list"));
#endif
return 1;

remote_found:
*serial=i;
decrypt1(&m->var,&remotes[i].keeloq);
if(m->var.plaintext.discriminator != remotes[i].discriminator) return 2;
if(m->fix.buttons != m->var.plaintext.buttons) return 3;

*buttons = m->fix.buttons;

//now check whether the counter is in active or resyncs windows
uint16_t counter = m->var.plaintext.counter;
//handle resync now
if(resync[i]) 
	{
	if(counter==resync[i]) return 4; //accidentally repeatedly received
	if(counter==resync[i]+1) //success
                {
#ifdef debug
                printP(PSTR("resync OK\n"));
#endif
                remotes[i].counter=counter;
                resync[i]=0;
                return 0;
                }
	else
                {
#ifdef debug
                printP(PSTR("resync failed\n"));
#endif
                resync[i]=0;
                return 5;
                }
        }

//ignore if counter is equal or below stored counter
//request resync if counter is more than 16 advanced

{
int32_t cdiff;
cdiff=(int32_t)counter-(int32_t)remotes[i].counter; //treat correctly overflows
if(cdiff<=0 && cdiff >= -65500 ) return 6;
if(cdiff>16 || cdiff < -65500) //needs resync
        {
#ifdef debug
        printP(PSTR("resync requested\n"));
#endif
        resync[i]=counter;
        return 7;
        }
}
remotes[i].counter=counter; //store recent value

return 0;
}



#endif
