#include "keeloq1.h"
#include "keeloq2.h"


//struct REMOTE_ENTRY cf. keeloq1.h
#define N_REMOTES_GARAZ1 1
#define KEELOQ_GARAZ1_0 {0xffffffffffffffffLL,0xffffffffL,0x03ff,0}
#define KEELOQ_GARAZ1_ALL {KEELOQ_GARAZ1_0}

#define N_REMOTE_ALARM N_REMOTES_GARAZ1
#define KEELOQ_REMOTE_ALL {KEELOQ_GARAZ1_0}
#define REMOTES_LABELS {"jirka"}

//0,1 is real keyboard, 1 is virtual one
#define NKEYBOARDS 3
#define KEELOQ_KEYB_0 {0xffffffffffffffffLL,0xffffffffffffffffLL}
#define KEELOQ_KEYB_1 {0xffffffffffffffffLL,0xffffffffffffffffLL}
#define KEELOQ_KEYB_2 {0xffffffffffffffffLL,0xffffffffffffffffLL}
//depends on NKEYBOARDS
#define LOCATION_KEELOQ_KEYBOARDS_ALL {KEELOQ_KEYB_0,KEELOQ_KEYB_1,KEELOQ_KEYB_2,{0x0LL,0x0LL}}

//sensors: 0 = lock+alarmsensor, 1 = termostat
#define NSENSORS 2
#define KEELOQ_SENSOR_0 {0xffffffffffffffffLL,0xffffffffffffffffLL} 
#define KEELOQ_SENSOR_1 {0xffffffffffffffffLL,0xffffffffffffffffLL} 
#define LOCATION_KEELOQ_SENSORS_ALL {KEELOQ_SENSOR_0,KEELOQ_SENSOR_1,{0x0LL,0x0LL}}

//actually not each sensor has a thermometer, but we would need another mapping array...so at the moment formally
//have the possibility that any sensor will transmit temperature...
#define NTHERMOMETERS NSENSORS 
//this is the outside thermo/hygro/barometer
#define METEOSENSOR 1
//this is the outside anemometer and rain gauge
#define METEOSENSOR2 1

//enlarge this depending on NSENSORS
#define WIRELESS_SENSOR_PING_TIMEOUTS {0} 
#define WIRELESS_PING_OKRUH {-1}



#define NACTORS 2
/*0 is lock, 1 is thermostat */
#define KEELOQ_ACTOR_0 {0xffffffffffffffffLL,0xffffffffffffffffLL}
#define KEELOQ_ACTOR_1 {0xffffffffffffffffLL,0xffffffffffffffffLL}
#define LOCATION_KEELOQ_ACTORS_ALL {KEELOQ_ACTOR_0,KEELOQ_ACTOR_1,{0x0LL,0x0LL}}

//trick to force the preprocessor to substitute correctly
#define LOCATION_KEELOQ_KEYBD2(N) KEELOQ_KEYB_##N
#define LOCATION_KEELOQ_KEYBOARD(N) LOCATION_KEELOQ_KEYBD2(N)
#define LOCATION_KEELOQ_SENSOR2(N) KEELOQ_SENSOR_##N
#define LOCATION_KEELOQ_SENSOR(N) LOCATION_KEELOQ_SENSOR2(N)
#define LOCATION_KEELOQ_ACTOR2(N) KEELOQ_ACTOR_##N
#define LOCATION_KEELOQ_ACTOR(N) LOCATION_KEELOQ_ACTOR2(N)


//NOTE: hashes are generated from cleartext by keeloqhash.c
typedef char PASSWDNAME[16];

#define N_PASSWORD_ALARM 5
#define PASSWORDS_ALARM {"ffffffff","ffffffff","ffffffff","ffffffff","ffffffff"}
#define PASSWORDS_NAMES_ALARM {"","","","",""}
#define PASSWORDS_HASH_ALARM {0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff}
#define PASSWORDS_SALT_ALARM 0xffffffffffffffffLL

#define N_PASSWORD_DUM N_PASSWORD_ALARM
#define PASSWORDS_DUM PASSWORDS_ALARM
#define PASSWORDS_NAMES_DUM PASSWORDS_NAMES_ALARM
#define PASSWORDS_HASH_DUM PASSWORDS_HASH_ALARM
#define PASSWORDS_SALT_DUM PASSWORDS_SALT_ALARM


#define N_CIRCUITS 10
#define ALARM_ASSIGNMENT \
{ \
/*00*/ "", \
/*01*/ "", \
/*02*/ "", \
/*03*/ "", \
/*04*/ "", \
/*05*/ "", \
/*06*/ "", \
/*07*/ "", \
/*08*/ "zamek", \
/*09*/ "zamek_badpass", \
}
#define OKRUH_OFFSET 8

#define OKRUH_GARAZ_VIRT 9
#define FIRE_CIRCUIT -1
#define FIRE_TEMP_THRESHOLD 500
#define OKRUH_GARAZ_CRITICAL -1
#define FIRE_GARAZ -1
#define GAS_GARAZ -1
#define LEFT_DOOR_GARAZ -1
#define RIGHT_DOOR_GARAZ -1

#define N_CAMERA 1
#define CAMERA_LIST {""}

//which camera to activate when alarm is raised on a given circuit
#define CAMERA_ASSIGNMENT \
{ \
/*00*/ 0, \
/*01*/ 0, \
/*02*/ 0, \
/*03*/ 0, \
/*04*/ 0, \
/*05*/ 0, \
/*06*/ 0, \
/*07*/ 0, \
/*08*/ 0, \
/*09*/ 0, \
}


#define LED_STATUS_CIRCUIT -1

#define CIRCUITS_SWITCHING_SIRENA \
{ \
{600,600,600,600,600,600,600,600,600,600},\
{060,060,060,060,060,060,060,060,060,060},\
}

#define CIRCUITS_SWITCHING_SIRENKA \
{ \
{120,120,120,120,120,120,120,120,120,120},\
{012,012,012,012,012,012,012,012,012,012},\
}


#define DAY_HOUR 6
#define NIGHT_HOUR 21

//buttons of HCS301-remote control
#define BUTTON_I 0x02
#define BUTTON_II 0x04
#define BUTTON_III 0x08
#define BUTTON_IV 0x01
#define BUTTON_RED 0x06
#define BUTTONS_TEXT { \
"no_buttons", \
"BUTTON_IV", \
"BUTTON_I", \
"undefined", \
"BUTTON_II", \
"BUT_II_IV", \
"BUTTON_RED", \
"undefined", \
"BUTTON_III", \
"BUT_III_IV", \
"BUT_I_III", \
"undefined", \
"undefined", \
"undefined", \
"undefined", \
"undefined" \
}


//delay when unlocking
#define ALARM_DELAYS {0,0,0,0,0,0,0,0,0,0}

#define CIRCUITS_STATUS_INITIAL {0,0,0,0,0,0,0,0,0,0}
#define CIRCUITS_STATUS_FORCE   {0,0,0,0,0,0,0,0,0,0}

//repeatedly notify via e-mail for = 2, one-shot =1
#define CIRCUITS_NOTIFY       {0,0,0,0,0,0,0,0,0,0} 
#define CIRCUITS_NOTIFY_EMAIL {0,0,0,0,0,0,0,0,0,0}

//0 - no change by this password
//1 - change by lockunlock
//2 - delay when locking/accept delay when unlocking
//4 - only clear alarm
//8 etc. - reserved
#define PASSWORDS_ACTIONS_ALARM {  \
{0,0,0,0,0,0,0,0,0,0}, \
{0,0,0,0,0,0,0,0,0,0}, \
{0,0,0,0,0,0,0,0,0,0}, \
}

#define PASSWORDS_ACTIONS_DO_NOTIFY {1,1,1};
#define PASSWORDS_ACTIONS_NOTIFY_EMAIL {0,0,0};
#define PASSWORDS_ACTIONS_NOTIFY_SMS {-1,-1,-1};

#define POWER_NOTIFY_EMAIL 0
#define POWER_NOTIFY_SMS 0

#define REMOTE_ACTIONS_NOTIFY_EMAIL {0,0,0};
#define REMOTE_ACTIONS_NOTIFY_SMS {-1,-1,-1};

#define REMOTES_ACTIONS_ALARM {  \
{0,0,0,0,0,0,0,0,0,0}, \
}

//for LAN incoming communication
#define ALARMGARAZ_IP "10.0.0.101"
#define ALARMSERVER_IP "10.0.0.100"
#define ALARMSERVER_UDP 1828

//for LAN outgoing communication
#define UDP_FORWARD 0
#define FORWARD_PORT 1829
#define FORWARD_IP inet_addr("")


//for alarm reports:

#define N_SMS 1
#define SMSS { \
"420000000000", \
}

#define RAIN_NOTIFY_SMS_ACTIVE {0}

#define N_EMAILS 1
#define EMAILS { \
"jiri@pittnerovi.com", \
}

#define RAIN_NOTIFY_EMAIL_ACTIVE {0}

#define TOSTRING2(x) #x
#define  TOSTRING(x)  TOSTRING2(x)

#define N_PASSWORD2(L) N_PASSWORD_##L
#define N_PASSWORD(L) N_PASSWORD2(L)
#define N_REMOTE2(L) N_REMOTE_##L
#define N_REMOTE(L) N_REMOTE2(L)
#define PASSWORDS2(L) PASSWORDS_##L
#define PASSWORDS(L) PASSWORDS2(L)
#define PASSWORDS_HASH2(L) PASSWORDS_HASH_##L
#define PASSWORDS_HASH(L) PASSWORDS_HASH2(L)
#define PASSWORDS_SALT2(L) PASSWORDS_SALT_##L
#define PASSWORDS_SALT(L) PASSWORDS_SALT2(L)
#define PASSWORDS_NAME2(L) PASSWORDS_NAMES_##L
#define PASSWORDS_NAME(L) PASSWORDS_NAME2(L)
#define PASSWORDS_ACTIONS2(L) PASSWORDS_ACTIONS_##L
#define PASSWORDS_ACTIONS(L) PASSWORDS_ACTIONS2(L) 
#define REMOTES_ACTIONS2(L) REMOTES_ACTIONS_##L
#define REMOTES_ACTIONS(L) REMOTES_ACTIONS2(L)


