/*
 * 	alarmserver.c ... alarm and home automation central and weater station receiver
 *
 * 	Copyright (C) 2006-2014 Jiri Pittner <jiri@pittnerovi.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 	                                         
 * 	                                        
*/

//set this to include proper keys.h file
#define LOCATION plzen


#undef debug

//TODO:
//@@@@@@select nefunguje spravne - blokuje se read z ttyama0 - zkusit jeste stty na raw line discipline a -echo
//@@@@@ reopenlogfile i kdyz ceka na vstupy v selectu?
//@@@@@@ on emergency button also send dial command to smsserver
//@@@ sms command to force reboot
//@@@ generovani a vyslani obycejneho keeloq message - portable standalone program
//@@@ watchdogging mutually atmel and cris  ... cris bude posilat pravidelne nejaky prikaz atmelu, kdyz ho ten nedostane, vypne a zapne crisu napajeni
//@@@implement some additional primitive authentization, like a password, or better some encryption of the whole SMS
//? lock file aby copymeteo necetlo file v momente kdy se do nej zapisuje - slo by to udelat efektivne? podporuje to scp???
//? promenny pocet hesel, master heslo s indexm 0, master+suffix - next will be password to learn (with suffix on which position)
//
//on G20 atmel is at ttyS3
//
#ifdef G20
#define DAPAG20_RESET 64
#define DAPAG20_SCK 65
#define DAPAG20_DOUT 66
#define DAPAG20_DIN 67
//file names in sysfs
#define GPIODIR2(N) "/sys/class/gpio/gpio" #N "/direction"
#define GPIOVAL2(N) "/sys/class/gpio/gpio" #N "/value"
//due to lack of recursion in preprocessor
#define GPIODIR(N) GPIODIR2(N)
#define GPIOVAL(N) GPIOVAL2(N)
#endif


#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <termios.h>
#include <unistd.h>
#include <math.h>
#include <sys/types.h>
#include <grp.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/select.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <sys/ioctl.h>
#include <pwd.h>
#include <sys/prctl.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#ifndef emulate
#ifdef CRIS
#include <asm/etraxgpio.h>
#endif
#endif

#ifndef emulate
#ifdef CRIS
#define MAILCOMMAND "/usr/local/bin/mail"
#endif
#ifdef ARM
#define MAILCOMMAND "/bin/mail"
#endif
#ifdef RPI
#define MAILCOMMAND "/usr/bin/mail"
#else
#define MAILCOMMAND "/bin/mail"
#endif
#endif

#define COUNTER32
typedef uint32_t counter_t;

#define INCFILE_PARAMS_(X) X##_params.h
#define INCFILE_PARAMS(X) INCFILE_PARAMS_(X)
#define INCFILE_KEYS_(X) X##_keys.h
#define INCFILE_KEYS(X) INCFILE_KEYS_(X)
#define STR(s) #s
#define XSTR(s) STR(s)

#define STRLOCATION XSTR(LOCATION)

#include XSTR(INCFILE_PARAMS(LOCATION))
#include "../atmel/keeloq1.h"
#include "../atmel/keeloq1.c"
#include "../atmel/keeloq2.h"
#include "../atmel/keeloq2.c"
#include XSTR(INCFILE_KEYS(LOCATION))
#include "../atmel/devices433.h"
#include "../atmel/meteo2.h"

#ifdef G20
void atmel_reset(void)
{
int g20_reset;
FILE *f;
        if ((f = fopen("/sys/class/gpio/export", "w")) == NULL) {
                perror("cannot write to /sys/class/gpio/export");
                exit(1);
                }
        fprintf(f,"%d\n",DAPAG20_RESET); fflush(f);
        fprintf(f,"%d\n",DAPAG20_SCK); fflush(f);
        fprintf(f,"%d\n",DAPAG20_DIN); fflush(f);
        fprintf(f,"%d\n",DAPAG20_DOUT); fflush(f);
        fclose(f);

        if ((f = fopen(GPIODIR(DAPAG20_RESET), "w")) == NULL) {
                perror("cannot open direction file");
                exit(1);
                }
        fprintf(f,"out\n");
        fclose(f);
	
	g20_reset = open(GPIOVAL(DAPAG20_RESET),O_WRONLY);
        if(g20_reset<0) {perror(GPIOVAL(DAPAG20_RESET)); exit(1);}

	write(g20_reset,"0\n",2);
	sleep(1);
	write(g20_reset,"1\n",2);
	close(g20_reset);
}
#endif


#ifdef CRIS
void atmel_reset(void)
{
  int fdg;
  int iomask_g;
  int i=0;

  if ((fdg = open("/dev/gpiog", O_RDWR))<0) {
    fprintf(stderr,"ERROR  /dev/gpiog\n");
    return ;
  }
  iomask_g = (1<<1); //OG1
  ioctl(fdg, _IO(ETRAXGPIO_IOCTYPE, IO_SETOUTPUT),&iomask_g);

int r;
    r=ioctl(fdg, _IO(ETRAXGPIO_IOCTYPE, IO_CLRBITS),  (1<<1));  
sleep(1);
    r=ioctl(fdg, _IO(ETRAXGPIO_IOCTYPE, IO_SETBITS),  (1<<1)); 

  close(fdg);
}
#endif

#ifdef RPI
void atmel_reset(void)
{
system("/usr/local/bin/uisp --rd_fuses -dprog=daparpi 2>/dev/null > /dev/null");
}
#endif



typedef char NAME16[16];
const NAME16 alarm_assignment[N_CIRCUITS] = ALARM_ASSIGNMENT;
const NAME16 camera_list[N_CAMERA] = CAMERA_LIST;
static int camera_was_sent[N_CAMERA]; //zero initialized
const int camera_assignment[N_CIRCUITS] = CAMERA_ASSIGNMENT;
static char camerascript[128]="/usr/local/alarm/camerascript";
static uint8_t circuits_alarm[N_CIRCUITS];
static uint8_t circuits_status[N_CIRCUITS] = CIRCUITS_STATUS_INITIAL;
static const uint8_t circuits_status_force[N_CIRCUITS] = CIRCUITS_STATUS_FORCE;
static const int circuits_delays[N_CIRCUITS] = ALARM_DELAYS;
static time_t circuits_delayed_alarm[N_CIRCUITS]; //null initialized
static uint8_t circuits_notify[N_CIRCUITS] = CIRCUITS_NOTIFY; //zero-initialized
static int circuits_notify_email[N_CIRCUITS] = CIRCUITS_NOTIFY_EMAIL; //zero-initialized
static int passwords_actions_do_notify[N_PASSWORD_ALARM] = PASSWORDS_ACTIONS_DO_NOTIFY;
static int passwords_actions_notify_email[N_PASSWORD_ALARM] = PASSWORDS_ACTIONS_NOTIFY_EMAIL;
static int passwords_actions_notify_sms[N_PASSWORD_ALARM] = PASSWORDS_ACTIONS_NOTIFY_SMS;
static int remote_actions_notify_email[N_REMOTE_ALARM] = REMOTE_ACTIONS_NOTIFY_EMAIL;
static int remote_actions_notify_sms[N_REMOTE_ALARM] = REMOTE_ACTIONS_NOTIFY_SMS;
#ifdef REMOTE_DIRECT_NOTIFY_EMAIL
static int remote_direct_notify_email[N_REMOTE_ALARM] = REMOTE_DIRECT_NOTIFY_EMAIL;
#endif
#ifdef REMOTE_DIRECT_NOTIFY_SMS
static int remote_direct_notify_sms[N_REMOTE_ALARM] = REMOTE_DIRECT_NOTIFY_SMS;
#endif
static int circuits_notify_sms[N_CIRCUITS]; //zero-initialized
static time_t last_command_time=0;
static int wireless_sensor_ping_timeouts[NSENSORS] = WIRELESS_SENSOR_PING_TIMEOUTS;
static time_t wireless_sensor_ping_last[NSENSORS]; //zero initialized
static time_t heatcool_timestamp;
static time_t heater_ontime[NSENSORS]; //will be used only for thermostat sensors
static time_t cooler_ontime[NSENSORS]; //will be used only for thermostat sensors
static time_t heater_started[NSENSORS]; //will be used only for thermostat sensors
static time_t cooler_started[NSENSORS]; //will be used only for thermostat sensors
static time_t udp_last; //zero initialized
static int wireless_ping_okruh[NSENSORS] = WIRELESS_PING_OKRUH;
static NAME16 buttonstext[16] = BUTTONS_TEXT;
static NAME16 remotes_labels[N_REMOTE_ALARM] = REMOTES_LABELS;
typedef uint8_t ACTION_ALARM[N_CIRCUITS];
static const ACTION_ALARM password_actions[N_PASSWORD(ALARM)] = PASSWORDS_ACTIONS(ALARM);
static const ACTION_ALARM remotes_actions[N_REMOTE(ALARM)] = REMOTES_ACTIONS(ALARM);
static const int circuits_switching_sirena[2][N_CIRCUITS]=CIRCUITS_SWITCHING_SIRENA;
static const int circuits_switching_sirenka[2][N_CIRCUITS]=CIRCUITS_SWITCHING_SIRENKA;
static const int rain_notify_sms_active[N_SMS] = RAIN_NOTIFY_SMS_ACTIVE;
static const int rain_notify_email_active[N_EMAILS] = RAIN_NOTIFY_EMAIL_ACTIVE;

//forwarding of wireless packets via internet
static const int udp_forward=UDP_FORWARD;
static int forward_udp_descr=0;

//misc
static int isday;
static int ignorezkrat=0;

static REMOTE_ENTRY remotes[N_REMOTE(ALARM)] = KEELOQ_REMOTE_ALL;
static uint16_t remote_resyncs[N_REMOTE(ALARM)];

void xerror(error_text)
char error_text[];
{

        fprintf(stderr,"alarmserver: %s\n",error_text);
        exit(10);
}




static struct termios devicetermios0, ttytermios0;
static int filehandle;


void sirenes_off()
{
FILE *fsms  = fopen("/usr/local/alarm/smsserver.pid","r");
if(fsms)
	{
	int smsserver_pid;
	if(1==fscanf(fsms,"%d",&smsserver_pid)) kill(smsserver_pid,SIGHUP); //flush the queue of sms and calls
	fclose(fsms);
	}

write(filehandle,"S 0\n",4);
struct timespec req;
req.tv_sec=0;
req.tv_nsec = 50000000;
nanosleep(&req,NULL); //atmel nestiha
write(filehandle,"s 0\n",4);
}

void sirenes_on(int okruh)
{
char cmd[16];
if(isday<0||isday>1 || okruh<0||okruh>=N_CIRCUITS) return; //prevent core dump in case of errorneous input
if(circuits_switching_sirena[isday][okruh]) {sprintf(cmd,"S %d\n",circuits_switching_sirena[isday][okruh]); write(filehandle,cmd,strlen(cmd)); }
struct timespec req;
req.tv_sec=0;
req.tv_nsec = 50000000;
nanosleep(&req,NULL); //atmel nestiha
if(circuits_switching_sirenka[isday][okruh]){sprintf(cmd,"s %d\n",circuits_switching_sirenka[isday][okruh]); write(filehandle,cmd,strlen(cmd)); }
}

void termioscleanup()
{
tcsetattr(fileno(stdin),TCSANOW,&ttytermios0);
tcsetattr(filehandle,TCSANOW,&devicetermios0);
}

void handler()
{
termioscleanup();
exit(0);
}


void usage()
{
exit(1);
}

#define MAXPACKET 255
#define MAXLINE (2*MAXPACKET+2)

uint8_t letter2bin (char c)
{
return c>'9' ? c+10-(c>='a'?'a':'A') : c-'0';
}


uint8_t octet2bin(char* octet)
{
return (letter2bin(octet[0])<<4) | letter2bin(octet[1]);
}

void bin2letter(char *c, uint8_t b)
{
*c = b<10? '0'+b : 'A'+b-10;
}

void bin2octet(char *octet, uint8_t bin)
{
bin2letter(octet,bin>>4);
bin2letter(octet+1,bin&0x0f);
}



static const KEELOQ_CODE2 keeloq_keyboard_crypts[] = LOCATION_KEELOQ_KEYBOARDS_ALL;
static const KEELOQ_CODE2 keeloq_sensor_crypts[] = LOCATION_KEELOQ_SENSORS_ALL;
static const KEELOQ_CODE2 keeloq_actor_crypts[] = LOCATION_KEELOQ_ACTORS_ALL;

const KEELOQ_CODE2 *keeloq_all[MAX_DEVICE_TYPES] = {keeloq_keyboard_crypts,keeloq_sensor_crypts,keeloq_actor_crypts};

//automatically zero-initialized //will be read from a permament file storage at program start
#define COUNTERS_FILE "/usr/local/alarm/counters"
static counter_t keyboard_counters[NKEYBOARDS];
static counter_t keyboard_resyncs[NKEYBOARDS];
static counter_t sensor_counters[NSENSORS];
static counter_t sensor_resyncs[NSENSORS];
static counter_t actor_counters[NACTORS];
static counter_t actor_resyncs[NACTORS];

counter_t *counters_all[MAX_DEVICE_TYPES] = {keyboard_counters,sensor_counters,actor_counters};

//counters have been zeroed at startup if read fails
void read_counters()
{
int f=open(COUNTERS_FILE,O_RDONLY);
if(f>=0)
	{
	int r;
	unsigned char counts[4];
	r=read(f,counts,4*sizeof(unsigned char));
	if(counts[0]>NKEYBOARDS|| counts[1]>NSENSORS || counts[2]>NACTORS||counts[3]>N_REMOTE(ALARM))
		{
		//file mismatch
		close(f);
		return;
		}
	r=read(f,keyboard_counters,counts[0]*sizeof(counter_t));
	r=read(f,sensor_counters,counts[1]*sizeof(counter_t));
	r=read(f,actor_counters,counts[2]*sizeof(counter_t));
	int i;
	for(i=0; i<N_REMOTE(ALARM); ++i)
                r=read(f,&remotes[i].counter,sizeof(uint16_t));
	close(f);
	}
}

void save_counters()
{
int f=open(COUNTERS_FILE,O_WRONLY|O_CREAT,0700);
if(f>=0)
        {
        int r;
	unsigned char counts[4]={NKEYBOARDS,NSENSORS,NACTORS,N_REMOTE(ALARM)};
	r=write(f,counts,4*sizeof(unsigned char));
        r=write(f,keyboard_counters,NKEYBOARDS*sizeof(counter_t));
        r=write(f,sensor_counters,NSENSORS*sizeof(counter_t));
        r=write(f,actor_counters,NACTORS*sizeof(counter_t));
	int i;
	for(i=0; i<N_REMOTE(ALARM); ++i)
		r=write(f,&remotes[i].counter,sizeof(uint16_t));
        close(f);
        }
}

#define CIRCUITS_FILE "/usr/local/alarm/circuits"
static int savecircuits;
void save_circuits()
{
int f=open(CIRCUITS_FILE,O_WRONLY|O_CREAT,0700);
if(f>=0)
        {
        int r;
	r=write(f,circuits_alarm,sizeof(circuits_alarm));
	r=write(f,circuits_status,sizeof(circuits_status));
        close(f);
        }
}


//assuming that initialization took place (if read is not succesfull)
void read_circuits()
{
int f=open(CIRCUITS_FILE,O_RDONLY);
if(f>=0)
        {
	int r;
	r=read(f,circuits_alarm,sizeof(circuits_alarm));
	r=read(f,circuits_status,sizeof(circuits_status));
	}
int i;
for(i=0; i<N_CIRCUITS; ++i) circuits_status[i] |= circuits_status_force[i];
}


static uint32_t passwords_hash[N_PASSWORD(ALARM)] = PASSWORDS_HASH(ALARM);
static PASSWDNAME passwords_name[N_PASSWORD(ALARM)] = PASSWORDS_NAME(ALARM);
static int bad_attempts=0;

typedef char EMAIL[64];
static EMAIL emails[N_EMAILS] = EMAILS;

typedef char SMS[16];
static SMS smss[N_SMS] = SMSS;

static int smsfifodescr;

void reset_notify(FILE *logfile,char *timestamp, int email, int sms)
{
if(email>=0)
        {
        char command[256];
        sprintf(command,MAILCOMMAND " -s RESET_NOTIFY %s",emails[email]);
        FILE *p;
        p=popen(command,"w");
        if(!p) fprintf(logfile,"Error sending e-mail %s\n",emails[email]);
	else
		{
		fprintf(p,"%s Alarm RESET! %s\n",STRLOCATION,timestamp);
        	pclose(p);
		}
        }
}

void sms_notify(FILE *logfile,char *timestamp, int email,char *text)
{
if(email>=0)
        {
        char command[256];
        sprintf(command,MAILCOMMAND " -s INCOMING_SMS %s",emails[email]);
        FILE *p;
        p=popen(command,"w");
        if(!p) fprintf(logfile,"Error sending e-mail %s\n",emails[email]);
	else
		{
		fprintf(p,"%s: %s: INCOMING SMS: %s\n",STRLOCATION,timestamp,text);
        	pclose(p);
		}
        }
}

void power_notify(FILE *logfile,char *timestamp,int onoff, char *location)
{
if(POWER_NOTIFY_EMAIL>=0)
	{
        char command[256];
        sprintf(command,MAILCOMMAND " -s POWER_NOTIFY %s",emails[POWER_NOTIFY_EMAIL]);
        FILE *p;
        p=popen(command,"w");
        if(!p) fprintf(logfile,"Error sending e-mail %s\n",emails[POWER_NOTIFY_EMAIL]);
        else
                {
                fprintf(p,"%s AC POWER NOTIFY %s changed to %d\n",location,timestamp,onoff);
                pclose(p);
                }
	}

if(POWER_NOTIFY_SMS>=0)
        {
        char command[256];
        sprintf(command,"S %s %s AC POWER NOTIFY %s changed to %d\n",smss[POWER_NOTIFY_SMS],location,timestamp,onoff);
        write(smsfifodescr,command,strlen(command));
        }
}


void action_notify(FILE *logfile,char *timestamp, char *namex, int serial, int lockunlock, char *suffix, int email, int sms)
{
if(email>=0)
        {
        char command[256];
        sprintf(command,MAILCOMMAND " -s ACTION_NOTIFY_%s %s",namex,emails[email]);
        FILE *p;
        p=popen(command,"w");
        if(!p) fprintf(logfile,"Error sending e-mail %s\n",emails[email]);
	else
		{
		fprintf(p,"%s ACTION NOTIFY %s keyboard %d password %s suffix %s action %s\n",STRLOCATION,timestamp,serial,namex,suffix,lockunlock?"lock":"unlock");
        	pclose(p);
		}
        }

if(sms>=0)
	{
	char command[256];
        sprintf(command,"S %s %s ACTION NOTIFY %s keyboard %d password %s suffix %s action %s\n",smss[sms],STRLOCATION,timestamp,serial,namex,suffix,lockunlock?"lock":"unlock");
        write(smsfifodescr,command,strlen(command));
	}
}

void lock_notify(FILE *logfile,char *timestamp, int serial, int lockunlock, int password, int keyboard, int suffix)
{
#ifdef LOCK_NOTIFY_EMAIL
        {
        char command[256];
        sprintf(command,MAILCOMMAND " -s LOCK_NOTIFY_%s %s",STRLOCATION,LOCK_NOTIFY_EMAIL);
        FILE *p;
        p=popen(command,"w");
        if(!p) fprintf(logfile,"Error sending e-mail %s\n",LOCK_NOTIFY_EMAIL);
	else
		{
		fprintf(p,"LOCK NOTIFY location %s serial %d action %s at %s due to password %s on keyboard %d, suffix %d\n",STRLOCATION,serial,lockunlock?"lock":"unlock",timestamp,(((password&0xff)==0xff)?"NONE":passwords_name[password]),keyboard,suffix);
        	pclose(p);
		}
        }
#endif

#ifdef LOCK_NOTIFY_SMS
	{
	char command[256];
        sprintf(command,"S %s LOCK NOTIFY location %s serial %d action %s at %s due to password %s on keyboard %d, suffix %d\n",LOCK_NOTIFY_SMS,STRLOCATION,serial,lockunlock?"LOCK":"UNLOCK",timestamp,(((password&0xff)==0xff)?"NONE":passwords_name[password]),keyboard,suffix);
        write(smsfifodescr,command,strlen(command));
	}
#endif
}


armdisarm_notify(FILE *logfile, char *timestamp,int serial,int iremote, int email, int sms, char *action)
{
if(email>=0)
        {
        char command[256];
        sprintf(command,MAILCOMMAND " -s REMOTE_NOTIFY_%s %s",remotes_labels[iremote],emails[email]);
        FILE *p;
        p=popen(command,"w");
        if(!p) fprintf(logfile,"Error sending e-mail %s\n",emails[email]);
	else
		{
		fprintf(p,"%s REMOTE NOTIFY at %s: alarmsensor %d remote %d=%s action %s\n",STRLOCATION,timestamp,serial,iremote,remotes_labels[iremote],action);
        	pclose(p);
		}
        }

if(sms>=0)
	{
	char command[256];
        sprintf(command,"S %s %s REMOTE NOTIFY at %s: alarmsensor %d remote %d=%s action %s\n",smss[sms],STRLOCATION,timestamp,serial,iremote,remotes_labels[iremote],action);
        write(smsfifodescr,command,strlen(command));
	}
}

 
void rain_notify(char *timestamp, uint8_t stav)
{
int i;
for(i=0; i<N_EMAILS; ++i)
    if(rain_notify_email_active[i])
	{
	char command[256];
	sprintf(command,MAILCOMMAND " -s RAIN_%d %s",stav,emails[i]);
	FILE *p;
	p=popen(command,"w");
	fprintf(p,"%s RAIN %s : %s\n",STRLOCATION,timestamp,stav?"started":"stopped");
	pclose(p);
	sleep(1);
	}

for(i=0; i<N_SMS; ++i)
    if(rain_notify_sms_active[i])
	{
	char command[256];
	sprintf(command,"S %s %s RAIN %s : %s\n",smss[i],STRLOCATION,timestamp,stav?"started":"stopped");
	write(smsfifodescr,command,strlen(command));
	}

}

void report_alarm(FILE *logfile,int okruh, int stav, char *timestamp, char *otherreason, int email_only)
{
int i;
for(i=0; i<N_EMAILS; ++i)
	{
	char command[256];
	sprintf(command,MAILCOMMAND " -s ALARM %s",emails[i]);
	FILE *p;
	p=popen(command,"w");
	if(!p) {fprintf(logfile,"Error sending e-mail %s\n",emails[i]); continue;}
	if(otherreason) fprintf(p,"%s ALARM_%s %s : %s\n",STRLOCATION,alarm_assignment[okruh],timestamp,otherreason);
	else fprintf(p,"%s ALARM %s : %s %s\n",STRLOCATION,timestamp,alarm_assignment[okruh],alarm_status[stav]);
	pclose(p);
	sleep(1);
	}

if(email_only) return;

for(i=0; i<N_SMS; ++i)
	{
	char command[256];
	if(otherreason)  sprintf(command,"S %s %s ALARM %s : %s\n",smss[i],STRLOCATION,timestamp,otherreason);
	else sprintf(command,"S %s %s ALARM %s : %s %s\n",smss[i],STRLOCATION,timestamp,alarm_assignment[okruh],alarm_status[stav]);
	write(smsfifodescr,command,strlen(command));
	}

//send pictures from a camera if relevant
if(camera_assignment[okruh] && !camera_was_sent[camera_assignment[okruh]]) 
	{
	camera_was_sent[camera_assignment[okruh]]=1;
	pid_t ff=fork();
	if(!ff) //child
		{
		FILE *p;
		char command[1024], tmp[256];
		sprintf(command,"%s %s ",camerascript,camera_list[camera_assignment[okruh]]);
		for(i=0; i<N_EMAILS; ++i) {sprintf(tmp,"%s ",emails[i]); strcat(command,tmp);}
		system(command);
		exit(0);
		}
	}

for(i=0; i<N_SMS; ++i)
        {
        char command[256];
        sprintf(command,"D %s\n",smss[i]);
        write(smsfifodescr,command,strlen(command));
        }
}

void report_local_alarm(FILE *logfile,int serial, const char *sensorstatus, const char *sensorname, const char *timestamp)
{
int i;
for(i=0; i<N_EMAILS; ++i)
	{
	char command[256];
	sprintf(command,MAILCOMMAND " -s SENSOR_LOCAL_ALARM_%s %s",sensorname,emails[i]);
	FILE *p;
	p=popen(command,"w");
	if(!p) {fprintf(logfile,"Error sending e-mail %s\n",emails[i]); continue;}
	fprintf(p,"%s SENSOR LOCAL ALARM %s : %d(%s) %s\n",STRLOCATION,timestamp,serial,sensorname,sensorstatus);
	pclose(p);
	sleep(1);
	}

for(i=0; i<N_SMS; ++i)
        {
        char command[256];
        sprintf(command,"S %s %s SENSOR LOCAL ALARM %s %s : %d %s\n",smss[i],STRLOCATION,sensorname,timestamp,serial,sensorstatus);
        write(smsfifodescr,command,strlen(command));
        }

for(i=0; i<N_SMS; ++i)
        {
        char command[256];
        sprintf(command,"D %s\n",smss[i]);
        write(smsfifodescr,command,strlen(command));
        }
}


uint8_t random_byte(void)
{
int x=open("/dev/random",O_RDONLY);
uint8_t r;
read(x,&r,1);
close(x);
return r;
}


uint8_t prepare_packet(FILE *logfile, char *timestamp, char *line, DEVICE device, SERIAL serial, uint32_t code, uint8_t count)
{
if(!count) {*line=0; return;}

//assemble message
uint8_t outcode[MESSAGE_BYTES];
{
message msg;
assemble_message32(device,serial,counters_all[device][serial]++,code,random_byte(),&msg);

//encrypt message, result in outcode
encrypt_message(&msg,outcode,keeloq_all[device][serial]);
}

//transform to ascii
if(count>9) count=9;
line[0]='T';
line[1]='0'+count;
line[2]=' ';
bin2octet(line+3,MESSAGE_BYTES*8);
line[5]=' ';
int i;
for(i=0; i<MESSAGE_BYTES; ++i) bin2octet(line+6+2*i,outcode[i]);
line[6+2*MESSAGE_BYTES]=0;
fprintf(logfile,"%s: Generated raw tx packet: %s\n",timestamp,line);
fflush(logfile);
return 6+2*MESSAGE_BYTES;
}

//not every sensor is a thermometer, but we do not a priori know which ones are
static int tempmax[NSENSORS];
static int tempmin[NSENSORS];
static int tempsum[NSENSORS]; 
static int tempcount[NSENSORS]; 
static int templast[NSENSORS];

static uint16_t fire_temp_threshold=FIRE_TEMP_THRESHOLD;

#define N_METEO 3
const double altitude[N_METEO] = {247., 417.}; //for pressure compensation
const double anemo_offset[N_METEO] = {45.,50.}; //anemometer can be mounted with an angular offset
static time_t last_rain_time[N_METEO];
static time_t last2_rain_time[N_METEO];
static double last_mm[N_METEO]={0.,0.};
#define YEAR 366
static double rain_cumulative[N_METEO][YEAR];
static int saverain=0;

static float last_wind_direction[N_METEO]={0.,0.};


//counters have been zeroed at startup if read fails
void read_rain()
{
	int r;
	int n;
	int i;
	int j;
	for(j=0; j<N_METEO; ++j) 
		{
		for(i=0; i<YEAR; ++i) rain_cumulative[j][i]=0;
		char name[128];
		sprintf(name,"/usr/local/alarm/meteo%d/rainsave",j);
		int f=open(name,O_RDONLY);
		if(f>=0)
			{
			r=read(f,&n,sizeof(int));
			if(r==sizeof(int))
				{
				if(YEAR<n) n=YEAR;
				r=read(f,rain_cumulative[j],n*sizeof(double));
				}
			close(f);
			}
		}
}


void save_rain()
{
int j;
for(j=0; j<N_METEO; ++j) 
{
char name[128];
sprintf(name,"/usr/local/alarm/meteo%d/rainsave",j);
int f=open(name,O_WRONLY|O_CREAT,0700);
if(f>=0)
        {
        int r;
	int n=YEAR;
	r=write(f,&n,sizeof(int));
        r=write(f,rain_cumulative[j],n*sizeof(double));
        close(f);
        }
}
}





static uint8_t keeloq1buf_old[8] = {0,0,0,0,0,0,0,0};

//just log the received code from a remote or perform an action when requested
uint16_t process_keeloq1(FILE *l, char *timestamp, const uint8_t *code)
{
	uint8_t serial,buttons;
	uint8_t wrkbuf[9];
	memcpy(wrkbuf,code,9);
	if(memcmp(wrkbuf,keeloq1buf_old,8))
		{
		memcpy(keeloq1buf_old,wrkbuf,8);
		uint8_t r=process_message(&buttons,&serial,wrkbuf,N_REMOTE_ALARM,remotes,remote_resyncs);
		if(r) {fprintf(l,"keeloq1 error status = %d\n",r); fflush(l); return r;}
		fprintf(l,"keeloq1 remote %d=%s counter %d button %d=%s\n",serial,remotes_labels[serial],remotes[serial].counter,buttons,buttonstext[buttons]);
		fflush(l);
#ifdef REMOTE_DIRECT_NOTIFY_EMAIL
#ifdef REMOTE_DIRECT_NOTIFY_SMS
		char message[256];
		sprintf(message,"user=%s button=%d action=%s",remotes_labels[serial],buttons,buttonstext[buttons]);
		armdisarm_notify(l,timestamp,-1,serial,remote_direct_notify_email[serial],remote_direct_notify_sms[serial],message);
#endif
#endif
		}
return 0;
}



#define POLY 0x8408
/*
//                                      16   12   5
// this is the CCITT CRC 16 polynomial X  + X  + X  + 1.
// This works out to be 0x1021, but the way the algorithm works
// lets us use 0x8408 (the reverse of the bit pattern).  The high
// bit is always assumed to be set, thus we only use 16 bits to
// represent the 17 bit value.
*/

uint16_t crc16(uint8_t *data_p, uint16_t length)
{
      unsigned char i;
      unsigned int data;
      unsigned int crc = 0xffff;

      if (length == 0)
            return (~crc);

      do
      {
            for (i=0, data=(uint16_t)0xff & *data_p++;
                 i < 8; 
                 i++, data >>= 1)
            {
                  if ((crc & 0x0001) ^ (data & 0x0001))
                        crc = (crc >> 1) ^ POLY;
                  else  crc >>= 1;
            }
      } while (--length);

      crc = ~crc;
      data = crc;
      crc = (crc << 8) | (data >> 8 & 0xff);

      return (crc);
}
#undef POLY



METEO2_DATAGRAM m2data_old = {0,0,0,0,0,0,0};
int islittleendian;
uint16_t process_meteo2(char *source, FILE *logfile, char *timestamp, const uint8_t *code)
{
#ifdef testing_meteo2_udp
if(strcmp(source,"wireless")==0) return 0; //ignore METEO2 packets received directly to check the UDP transfer
#endif
	METEO2_DATAGRAM m2data;
	memcpy(&m2data,code,sizeof(METEO2_DATAGRAM));
	if(!islittleendian) 
		{
		fprintf(logfile,"meteo2: byte swap needs to be implemented\n");
		exit(1);
		}
	if(memcmp(&m2data,&m2data_old,sizeof(METEO2_DATAGRAM))) //ignore repeated messages
		{
		memcpy(&m2data_old,&m2data,sizeof(METEO2_DATAGRAM));
		fprintf(logfile," meteo2 type %d serial %d report %d counter %d: ",m2data.device_type, m2data.serial, m2data.report_type,
#ifdef M2_COUNTER
        (unsigned int) m2data.counter
#else
        0
#endif
);
		//check CRC
		uint16_t crc=crc16((void *)&m2data,sizeof(METEO2_DATAGRAM)-2);
		if(crc!=m2data.crc) {fprintf(logfile,"CRC MISMATCH\n"); return 1;}
		
		//process the message
			if(m2data.serial>=N_METEO) {fprintf(logfile,"too high serial number %d\n",m2data.serial); return 2;}
			int serial = m2data.serial;
			if(m2data.device_type!= M2_METEOSTATION) {fprintf(logfile,"unrecognized device type %d\n",m2data.device_type); return 3;}
			switch(m2data.report_type)
				{
					case M2_RESET:
						fprintf(logfile,"reset! (args %d %d)\n",m2data.arg1,m2data.arg2);
						break;
					case M2_RAIN:
						{
						time_t tr = time(NULL);
						double mm = 0.55 * m2data.arg1;
						double hours = (tr-last_rain_time[serial])/3600.;
						double mmh = mm/hours;
						if(mmh>50) 
							{
							fprintf(logfile,"Rain unphysical %.1f raw readout %d collecting interval %.0f s\n",mmh,m2data.arg1,3600.*hours);fflush(logfile);
							break;
							}
						rain_cumulative[serial][0] += mm;
						if(mm>0) saverain=1;
						if(mm>0 && mmh < 0.1) mmh=0.1;
						double mmheff;
						double Tr=m2data.arg2*0.01;
						if(mmh>0 || hours>5.) mmheff=mmh; //either something rained, or long since last bucket
						else mmheff = last_mm[serial]*3600./((double) tr - last2_rain_time[serial]); //average overlast bucket over longer time
						
						fprintf(logfile,"Rain = %.1fmm/h raw %.1fmm/h Tr=%.2f (raw readout %d temp %d) collecting interval %.0f s\n",mmheff,mmh,Tr,m2data.arg1,m2data.arg2,3600.*hours);
                                                        {
                                                        char name[128];
							FILE *f;
                                                        	sprintf(name,"/usr/local/alarm/meteo%d/rain",serial);
                                                        	f=fopen(name,"w");
                                                        	if(f)
                                                                	{
									fprintf(f,"%.1f",mmheff);
                                                                	fclose(f);
                                                                	}
								sprintf(name,"/usr/local/alarm/meteo%d/temprain",serial);
                                                                f=fopen(name,"w");
                                                                if(f)
                                                                        {
                                                                        fprintf(f,"%.2f",Tr);
                                                                        fclose(f);
                                                                        }
							if(mmh>0)
							    {
								sprintf(name,"/usr/local/alarm/meteo%d/rainlast",serial);
                                                        	f=fopen(name,"w");
                                                        	if(f)
                                                                	{
                                                              	  	fprintf(f,"%.1f",mmh);
                                                                	fclose(f);
                                                                	}
						   	    }
								sprintf(name,"/usr/local/alarm/meteo%d/raindaily",serial);
                                                        	f=fopen(name,"w");
                                                        	if(f)
                                                                	{
                                                                	fprintf(f,"%.1f",rain_cumulative[serial][0]);
                                                                	fclose(f);
                                                                	}
								sprintf(name,"/usr/local/alarm/meteo%d/rainweekly",serial);
                                                        	f=fopen(name,"w");
                                                        	if(f)
                                                                	{
                                                                	fprintf(f,"%.1f",rain_cumulative[serial][0]+rain_cumulative[serial][1]+rain_cumulative[serial][2]+rain_cumulative[serial][3]+rain_cumulative[serial][4]+rain_cumulative[serial][5]+rain_cumulative[serial][6]);
                                                                	fclose(f);
                                                                	}

                                                        }
						if(mm>0) {last2_rain_time[serial] = last_rain_time[serial]; last_rain_time[serial] = tr; last_mm[serial]=mm;}
						}
						break;
					case M2_VOLTAGE:
						{
						float v = 0.01*m2data.arg2;
						fprintf(logfile,"Voltage = %.2fV)\n",v);
						        {
                                                        char name[128];
							sprintf(name,"/usr/local/alarm/meteo%d/voltage",serial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.2f",v);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case M2_WATER_ALARM:
						{
						int onoff = m2data.arg1;
						float volts =  0.001 * (unsigned int) m2data.arg2; 
						fprintf(logfile,"Water flooding sensor %s (%.3fV)\n",onoff?"ALARM":"OK",volts);
						report_alarm(logfile,0, onoff, timestamp,(onoff?"BASEMENT FLOOD!":"BASEMENT OK"),1);
						}
						break;
					case M2_PING:
						fprintf(logfile,"PING %d\n",m2data.arg2);
						break;
					case M2_WATER_LEVEL:
						{
						int wserial = m2data.arg1;
						float level = 0.001 * (unsigned int) m2data.arg3; //meters
						float volume =  0.001 * (unsigned int) m2data.arg2; //cubic meters
						fprintf(logfile,"Water level %d = %.3fm, volume = %.3fm^3\n",wserial,level,volume);
						        {
                                                        char name[128];
							sprintf(name,"/usr/local/alarm/meteo%d/water%d",serial,wserial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.3f %.3f",level,volume);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case M2_LIGHT:
						{
						float ohm=0.; 
						if(sizeof(uint32_t) == sizeof(float)) memcpy(&ohm,&m2data.arg3,sizeof(float));
						double lx = exp(-1.56544*log(ohm)+17.3907693); //calibrated from a fit for a given photoresistor, however it can differ even piece to piece
						fprintf(logfile,"Illuminance = %.1flx (resistance %.2f)\n",lx,ohm);
						        {
                                                        char name[128];
							sprintf(name,"/usr/local/alarm/meteo%d/light",serial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",lx);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case M2_PRESSURE:
						{
                                                float p= m2data.arg3*0.01;
						float t= m2data.arg2*0.01;
						const float mgR=0.03416319473631;	
						const float lapse_rate = -0.0065 ;
						float p2=p * expf(mgR*altitude[serial]/(273.15+t));
						float p3=p * powf((273.15+t)/(273.15+t-lapse_rate*altitude[serial]),mgR/lapse_rate);
						fprintf(logfile,"Pressure = %.2fhPa (at zero altitude %.2fhPa or with lapse rate %.2fhPa)\n",p,p2,p3);
						        {
                                                        char name[128];
                                                        sprintf(name,"/usr/local/alarm/meteo%d/pressure",serial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.2f",p);
                                                                fclose(f);
                                                                }
                                                        sprintf(name,"/usr/local/alarm/meteo%d/pressurecorr",serial);
                                                        f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.2f",p2);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case M2_WIND:
					case M2_WIND_GUSTS:
						{
						double dir,speed;
						if(m2data.arg1) fprintf(logfile,"Anemo error %d new anemo found %d\n",m2data.arg1,m2data.arg2);
						dir=360./16/256*m2data.arg2;
						dir+=anemo_offset[serial]; if(dir>360.) dir -= 360.; //!!!correction to offset of the mounting
						speed=0.1/256*m2data.arg3;
						fprintf(logfile,"Wind %s direction %.0f degs (%d) speed %.1f m/s (%d)\n",((m2data.report_type)==M2_WIND_GUSTS)?"gusts":"",dir,m2data.arg1,speed,m2data.arg2);
						if(speed==0.) dir = last_wind_direction[serial];
						if(speed<50.) //filter out unphysical results
						        {
							if(speed>0.) last_wind_direction[serial]=dir;
                                                        char name[128];
                                                        sprintf(name,"/usr/local/alarm/meteo%d/wind%s",serial,m2data.report_type==M2_WIND_GUSTS?"gusts":"");
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f %.2f",dir,speed);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case M2_TEMP_HUMID:
						{
						if(m2data.arg3 == M2_UNDEFINED_TEMP || m2data.arg2 == M2_UNDEFINED_HUMID) { fprintf(logfile,"undefined results reported\n"); return 5;}
                                                double t= m2data.arg3 * 0.01;
						double h= m2data.arg2 * 0.1;
						double dew;
						double m,tn;
						//dew point calculation by a formula from SHT75 datasheet (it is the Magnus formula, see also http://en.wikipedia.org/wiki/Dew_point for other parameters)
						if(t>=0) {m=17.62; tn=243.12;} else {m=22.46; tn=272.62;}
						if(h==0.) dew= -tn;
						else {dew=log(h*0.01)+m*t/(tn+t); dew= tn*dew/(m-dew);}
						fprintf(logfile,"Temperature = %.2fC Humidity = %.1f%% Dew point = %.2fC\n",t,h,dew);
						//print to a file for simple use by web server
							{
							char name[128];
							sprintf(name,"/usr/local/alarm/meteo%d/humidity",serial);
							FILE *f=fopen(name,"w");
							if(f)
								{
								fprintf(f,"%.1f",h);
								fclose(f);
								}
							sprintf(name,"/usr/local/alarm/meteo%d/dewpoint",serial);
                                                        f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.2f",dew);
                                                                fclose(f);
                                                                }
							sprintf(name,"/usr/local/alarm/meteo%d/temperature",serial);
							f=fopen(name,"w");
							if(f)
								{
								fprintf(f,"%.2f",t);
								fclose(f);
								}
							}
						}
						break;
					default:
						fprintf(logfile,"unknown meteostation code %02x args %d %d %d\n",m2data.report_type,m2data.arg1,m2data.arg2,m2data.arg3);
				}

		fflush(logfile);
		}
return 0;
}



uint16_t process_packet(char *source, FILE *logfile, char *timestamp, char *line, int *okruh, int *stav, int *issensor)
{
//parse line to byte sequence
int len;
uint8_t packet[MAXPACKET];

*issensor=0;

if(1!=sscanf(line,"R: %2x ",&len)) {fprintf(logfile,"wrong format from receiver\n"); return 100;}
int i;
for(i=0; i<(len+7)>>3; ++i) 
	{
	if(!line[2*i+6] || !line[2*i+7]) {fprintf(logfile,"truncated line from receiver\n"); return 200;}
	packet[i] = octet2bin(line + 2*i + 6);
	}

if(len>=0x40 && len <= 0x42)
	{
	return process_keeloq1(logfile,timestamp,packet);
	}

//this is not encrypted and should be trusted only when coming from a given openvpn IP or range
if(len== 8*sizeof(METEO2_DATAGRAM)) return process_meteo2(source,logfile,timestamp,packet);

//other lengths - try to decrypt it as keeloq2
uint8_t r;
message msg;
r=decrypt_message(&msg,packet,len,keeloq_all);
if(r) {fprintf(logfile,"packet decrypt error %d\n",r); return r;}

//try to disassemble it
DEVICE device;
SERIAL serial;
counter_t counter;
uint32_t payload;
r=disassemble_message32(&device,&serial,&counter,&payload,&msg);
if(r) {fprintf(logfile,"packet disassebmle error %d\n",r); return r;}

switch(device)
	{
	case KEYBOARD_DEVICE: 
		fprintf(logfile,"keyboard %d counter %d : ",serial,counter);
		//validate according to counters
		r=validate_message32(KEYBOARD_DEVICE, NKEYBOARDS, keyboard_counters, keyboard_resyncs, device, serial, counter, 0);
		if(r) {payload=0;fprintf(logfile,"validation error %d\n",r); return r;}

		//message is valid, find out which password matches
		char *suffix;
		uint8_t lockunlock;
		int16_t x=checkpassword(payload,N_PASSWORD(ALARM),passwords_hash,PASSWORDS_SALT(ALARM), &lockunlock, &suffix);
		payload=0;
		if(x<0)
			{
			++bad_attempts;
			fprintf(logfile,"BAD PASSWORD (%d)\n",bad_attempts);
			//make alarm if too many invalid password attempts - no sirenes, just report
			if(bad_attempts>=5) report_alarm(logfile,0,0,timestamp,"TOO MANY BAD PASSWORDS",0);
			return 1000;
			}
		bad_attempts=0;	
		fprintf(logfile,"password %s suffix (%s) action %s\n",passwords_name[x],suffix,lockunlock?"lock":"unlock");
		//perform requested action (if not suffix for camera only)
		if(strcmp(suffix,"11"))
		    {
		    uint8_t i;
		    savecircuits=1;
		    for(i=0; i<N_CIRCUITS; ++i)
			{
			if(password_actions[x][i]) 
				{
				camera_was_sent[camera_assignment[i]]=0;
				if((password_actions[x][i] & 0x04) ==0)
					circuits_status[i] = lockunlock?password_actions[x][i]:0;
				if(!lockunlock) { //clear circuit
						circuits_alarm[i] = 0; 
						sirenes_off(); 
						if(i==FIRE_CIRCUIT) fire_temp_threshold=FIRE_TEMP_THRESHOLD; //reset fire temperature threshold
						 } //all cleared
				}
			last_command_time=time(NULL);
			}

		    //special suffix dependent action (quiet alarm)
		    if(!strcmp(suffix,"99")) 
			{
			char text[128];
			sprintf(text,"EMERGENCY CODE from %s action %s",passwords_name[x],lockunlock?"lock":"unlock");
			report_alarm(logfile,0,0,timestamp,text,0);
			//@@@perhaps we whould NOT call/sms to the person who used this emergency code - but how to apss the info here who was it?
			}
		    }
		//notify on that action
		if(passwords_actions_do_notify[x])
			action_notify(logfile,timestamp,passwords_name[x],serial,lockunlock,suffix,passwords_actions_notify_email[x],passwords_actions_notify_sms[x]);
		break;
        case SENSOR_DEVICE:
		{
		fprintf(logfile,"sensor %d counter %d : ",serial,counter);
		CODE433 c; c.code=payload; //one bit of payload has to be used in advance to switch counter length before the whole has been verified - security risc?

                //validate according to counters
                r=validate_message32(SENSOR_DEVICE, NSENSORS, sensor_counters, sensor_resyncs, device, serial, counter, c.cmd.instr&LONGCOUNTER);
                if(r) {payload=0;fprintf(logfile,"validation error %d\n",r); return r;}

		wireless_sensor_ping_last[serial] = time(NULL);

		switch(c.cmd.instr&0x70) {
			case THERMOSTAT:
				fprintf(logfile,"unexpected event: thermostat should transmit with thermometer codes\n"); return 201;
			case THERMOMETER:
				fprintf(logfile,"thermometer %d: ",serial);
				switch(c.cmd.instr&0x0f) {
					case RESET_REPORT:
						fprintf(logfile,"reset! (args %d %d)\n",c.cmd.arg1,c.cmd.arg2);
						break;
					case RAINFALL_REPORT:
						{
						if(c.cmd.arg2) fprintf(logfile,"Rainfall %s\n",c.cmd.arg1?"started":"ended");
						else fprintf(logfile,"Rainfall %s\n",c.cmd.arg1?"continues raining":"continues dry");
						char name[128];
						FILE *f;
//only activate if the sensor becomes reliable and highly sensitive
#if 0
						if(c.cmd.arg2) //update rain file only on change in status
							{
							if(c.cmd.arg1) last_rain_time[0] = time(NULL);
							double mmh;
                                                        sprintf(name,"/usr/local/alarm/rain_%d",serial);
							int mmhread=0;
							f = fopen(name,"r");
							if(f)
                                                                {
								mmhread = fscanf(f,"%lf",&mmh);
								fclose(f);
								}
							if(mmhread && mmh==0. && c.cmd.arg1==1 || c.cmd.arg1==0)
								{
                                                        f=fopen(name,"w");
                                                        if(f)
                                                               {
                                                                if(c.cmd.arg1==0) fprintf(f,"0.0"); //zero rain intensity if not raining any more
								else fprintf(f,"0.1"); //if it is raining, but rain gauge did not register first bucket yet, set rain intensity to 0.1
                                                                fclose(f);
                                                               }
								}
							}
#endif
						//update the rainfall file always
                                                sprintf(name,"/usr/local/alarm/rainfall_%d",serial);
                                                f=fopen(name,"w");
                                                if(f)
                                                          {
                                                          fprintf(f,c.cmd.arg1?"YES":"NO");
                                                          fclose(f);
                                                          }
						//notify only on change of status
						if(c.cmd.arg2) rain_notify(timestamp,c.cmd.arg1);
						}
						break;
					case RAIN_REPORT:
						{
						time_t tr = time(NULL);
						double mm = 0.55 * c.cmd.arg2;
						double hours = (tr-last_rain_time[0])/3600.;
						double mmh = mm/hours;
						if(mmh>100.) 
							{
							fprintf(logfile,"Rain unphysical %.1f raw readout %d collecting interval %.0f s\n",mmh,c.cmd.arg1,3600.*hours);fflush(logfile);
							break;
							}
						rain_cumulative[0][0] += mm;
						if(mm>0) saverain=1;
						if(mm>0 && mmh < 0.1) mmh=0.1;
						double mmheff;
						if(mmh>0 || hours>5.) mmheff=mmh; //either something rained, or long since last bucket
						else mmheff = last_mm[0]*3600./((double) tr - last2_rain_time[0]); //average overlast bucket over longer time
						
						fprintf(logfile,"Rain = %.1fmm/h raw %.1fmm/h (raw readout %d is raining %d) collecting interval %.0f s\n",mmheff,mmh,c.cmd.arg2,c.cmd.arg1,3600.*hours);fflush(logfile);
                                                        {
                                                        char name[128];
							FILE *f;
								{
                                                        	sprintf(name,"/usr/local/alarm/rain_%d",serial);
                                                        	f=fopen(name,"w");
                                                        	if(f)
                                                                	{
									fprintf(f,"%.1f",mmheff);
                                                                	fclose(f);
                                                                	}
								}
							if(mmh>0)
								{
								sprintf(name,"/usr/local/alarm/rainlast_%d",serial);
                                                        	f=fopen(name,"w");
                                                        	if(f)
                                                                	{
                                                              	  	fprintf(f,"%.1f",mmh);
                                                                	fclose(f);
                                                                	}
								}
							sprintf(name,"/usr/local/alarm/raindaily_%d",serial);
                                                        f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",rain_cumulative[0][0]);
                                                                fclose(f);
                                                                }
							sprintf(name,"/usr/local/alarm/rainweekly_%d",serial);
                                                        f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",rain_cumulative[0][0]+rain_cumulative[0][1]+rain_cumulative[0][2]+rain_cumulative[0][3]+rain_cumulative[0][4]+rain_cumulative[0][5]+rain_cumulative[0][6]);
                                                                fclose(f);
                                                                }

                                                        }
						if(mm>0) {last2_rain_time[0] = last_rain_time[0]; last_rain_time[0] = tr; last_mm[0]=mm;}
						}
						break;
					case LIGHT_REPORT:
						{
                                                if(serial>=NSENSORS) {fprintf(logfile,"illegal serial number\n"); break;}
                                                int l= c.cmd.arg2;
						double ohm = 10240000./l-10000.;
						if(serial==5) ohm = (1024*2700./l-2700.)*2; //different schematics
						double lx = exp(-1.56544*log(ohm)+17.3907693); //calibrated from a fit for a particular sensor
						fprintf(logfile,"Illuminance = %.1flx (raw readout %d, resistance %.0f)\n",lx,c.cmd.arg2,ohm);
						        {
                                                        char name[128];
							if(serial==5) sprintf(name,"/usr/local/alarm/light%d_%d",c.cmd.arg1,serial);
                                                        else sprintf(name,"/usr/local/alarm/light_%d",serial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",lx);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case PRESSURE_REPORT:
						{
                                                if(serial>=NSENSORS) {fprintf(logfile,"illegal serial number\n"); break;}
                                                double p= c.cmd.arg2/10.;
						const double mgR=0.03416319473631;	
						double p2=p * exp(mgR*altitude[0]/(273.15+templast[serial]/10.));
						fprintf(logfile,"Pressure = %.1fhPa (at zero altitude %.1fhPa) [p_OK = %d]\n",p,p2,c.cmd.arg1);
						        {
                                                        char name[128];
                                                        sprintf(name,"/usr/local/alarm/pressure_%d",serial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",p);
                                                                fclose(f);
                                                                }
                                                        sprintf(name,"/usr/local/alarm/pressurecorr_%d",serial);
                                                        f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",p2);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case WIND_REPORT:
					case WIND_BLOW_REPORT:
						{
						double dir,speed;
                                                if(serial>=NSENSORS) {fprintf(logfile,"illegal serial number\n"); break;}
						dir=360./16/16*(unsigned int)c.cmd.arg1;
						dir+=anemo_offset[0]; if(dir>360.) dir -= 360.; //!!!correction to offset of the mounting
						speed=0.1/16*(unsigned int)c.cmd.arg2;
						fprintf(logfile,"Wind %s direction %.0f degs (%d) speed %.1f m/s (%d)\n",((c.cmd.instr&0x0f)==WIND_BLOW_REPORT)?"blow":"",dir,c.cmd.arg1,speed,c.cmd.arg2);
						if(speed==0.) dir = last_wind_direction[0];
						if(speed<50.) //filter out unphysical results
						        {
							if(speed>0.) last_wind_direction[0]=dir;
                                                        char name[128];
                                                        if((c.cmd.instr&0x0f)==WIND_BLOW_REPORT) sprintf(name,"/usr/local/alarm/windblow_%d",serial);
							else sprintf(name,"/usr/local/alarm/wind_%d",serial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.0f %.1f",dir,speed);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case HUMIDITY_REPORT:
						{
						if(serial>=NSENSORS) {fprintf(logfile,"illegal serial number\n"); break;}
                                                double t= c.cmd.arg2/10.;
						int h=c.cmd.arg1;
						double dew;
						{
						double m,tn;
						if(t>=0) {m=17.62; tn=243.12;} else {m=22.46; tn=272.62;}
						if(h==0) dew= -tn;
						else {dew=log(h/100.)+m*t/(tn+t); dew= tn*dew/(m-dew);}
						}
						fprintf(logfile,"Humidity = %d%% Dew point = %.1fC\n",h,dew);
						//print to a file for simple use by web server
							{
							char name[128];
							sprintf(name,"/usr/local/alarm/humidity_%d",serial);
							FILE *f=fopen(name,"w");
							if(f)
								{
								fprintf(f,"%d",h);
								fclose(f);
								}
							sprintf(name,"/usr/local/alarm/dewpoint_%d",serial);
                                                        f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",dew);
                                                                fclose(f);
                                                                }
							}
						}
						break;
					case TEMPERATURE_REPORT:
						{
						if(serial>=NSENSORS) {fprintf(logfile,"illegal serial number\n"); break;}
						int t=c.cmd.arg2;
						templast[serial]=t;
						if(t< tempmin[serial] )  tempmin[serial]=t;
						if(t> tempmax[serial] ) tempmax[serial]=t;
						++tempcount[serial];
						tempsum[serial]+= t;
						fprintf(logfile,"T %c %.1fC, min %.1f, max %.1f, av %.1f",((serial==0 && c.cmd.arg1 == '!') ? '!' : '='),t/10.,tempmin[serial]/10.,tempmax[serial]/10.,tempsum[serial]/((double)tempcount[serial])/10. );
						if(serial==5) fprintf(logfile," heater %s",c.cmd.arg1?"on":"off");
						fprintf(logfile,"\n");fflush(logfile);
						//print to a file for simple use by web server
							{
							char name[128];
							sprintf(name,"/usr/local/alarm/temperature_%d",serial);
							FILE *f=fopen(name,"w");
							if(f)
								{
								fprintf(f,"%.1f",t/10.);
								fclose(f);
								}
							}
						}
						break;
					case COUNTER_OUTPUT_REPORT:
						fprintf(logfile,"user has changed counter_output to %d\n",c.cmd.arg2);
						break;
					case REGIME_AND_HYST:
						fprintf(logfile,"user has set regime to %s or ",activelabel[c.cmd.arg1]);
						fprintf(logfile,"H_on = %d or H_off = %d\n", ((uint16_t) c.cmd.arg2)>>8, ((uint16_t) c.cmd.arg2)&0xff);
						break;
					case TEMPSET_AND_HEATCOOL:
					case TEMPERATURE_AND_HEATCOOL:
						{
						char name[64];
						if((c.cmd.instr&0x0f) == TEMPSET_AND_HEATCOOL) 
							{
							fprintf(logfile,"user has set T_opt = %.1fC; ",c.cmd.arg2/10.);
							sprintf(name,"/usr/local/alarm/tempset_%d",serial);
							FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",(double)c.cmd.arg2/10.);
                                                                fclose(f);
                                                                }

							}
						else 
							{
							fprintf(logfile,"T = %.1fC; ",c.cmd.arg2/10.);
							sprintf(name,"/usr/local/alarm/temperature_%d",serial);
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.1f",(double)c.cmd.arg2/10.);
                                                                fclose(f);
                                                                }
							}

						sprintf(name,"/usr/local/alarm/heater_%d",serial);
						if(c.cmd.arg1 & HEATER_ON) 
							{
							fprintf(logfile,"heater on");
							if(heater_started[serial] == 0) heater_started[serial] = time(NULL);
							}
						if(c.cmd.arg1 & HEATER_OFF) 
							{
							fprintf(logfile,"heater off");
							if(heater_started[serial]!=0) 
								{
								heater_ontime[serial] += time(NULL) - heater_started[serial];
								heater_started[serial]=0;
								}
                                                        }
						//update always because of duty
							{
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.3f %.1f %s",heater_ontime[serial]/3600.,heater_ontime[serial]*100./(time(NULL)-heatcool_timestamp),heater_started[serial]?"ON":"OFF" );
                                                                fclose(f);
                                                                }
							}

						sprintf(name,"/usr/local/alarm/cooler_%d",serial);
						if(c.cmd.arg1 & COOLER_ON)
							{
							fprintf(logfile,"cooler on");
							if(cooler_started[serial] == 0) cooler_started[serial] = time(NULL);
							}
						if(c.cmd.arg1 & COOLER_OFF) 
							{
							fprintf(logfile,"cooler off");
							if(cooler_started[serial]!=0) 
								{
								cooler_ontime[serial] += time(NULL) - cooler_started[serial];
								cooler_started[serial]=0;
								}
                                                        }
						//update always because of duty
							{
                                                        FILE *f=fopen(name,"w");
                                                        if(f)
                                                                {
                                                                fprintf(f,"%.3f %.1f %s",cooler_ontime[serial]/3600.,cooler_ontime[serial]*100./(time(NULL)-heatcool_timestamp),cooler_started[serial]?"ON":"OFF" );
                                                                fclose(f);
                                                                }
							}


						fprintf(logfile,"\n");
						}
						break;
					 case EFFECTIVE_TEMP:
						fprintf(logfile,"user has set eff_temp_from %d eff_temp_to %d eff_temp_kind %s\n",c.cmd.arg2>>8,c.cmd.arg2&0xff,eff_temp_label[c.cmd.arg1]);
						break;
					default:
						fprintf(logfile,"unknown thermometer code %02x args %d %d\n",c.cmd.instr&0x0f,c.cmd.arg1,c.cmd.arg2);
						return 203;
				}
				break;
			case ALARMSENSOR:
				fprintf(logfile,"alarmsensor %d: ",serial);
				switch(c.cmd.instr&0x0f) {
					case PING_REPORT:
						fprintf(logfile,"ping, is_armed %d, arg2 (voltage) %d",c.cmd.arg1,c.cmd.arg2);
						fprintf(logfile,"\n");fflush(logfile);
						if(c.cmd.arg2<120) power_notify(logfile,timestamp,c.cmd.arg2,"Garaz");
						break;
                                        case RESET_REPORT:
						fprintf(logfile,"reset\n");
						break;
					case SENSOR_REPORT:
						{
						*stav = c.cmd.arg2; 
						*okruh = c.cmd.arg1;
						fprintf(logfile,"wireless okruh %d %d\n",*okruh,*stav);
						if(*okruh >=16 && *okruh <N_CIRCUITS) *issensor = 1; //further process it as if it were from a hardwired sensor 0-15
						}
						break;
					case DISARM_REPORT:
					case ARM_REPORT: 
						{
						int lockunlock = ((c.cmd.instr&0x0f)==ARM_REPORT) ? 1 :0;
						int irm = c.cmd.arg2;
						savecircuits=1;
						//activate or deactivate corresponding circuits
		    				for(i=0; i<N_CIRCUITS; ++i)
						  {
						  if(remotes_actions[irm][i]) 
							{
							camera_was_sent[camera_assignment[i]]=0;
							if((remotes_actions[irm][i] & 0x04) ==0)
								circuits_status[i] = lockunlock?remotes_actions[irm][i]:0;
							if(!lockunlock) { //clear circuit
									circuits_alarm[i] = 0; 
									sirenes_off(); 
						 			} //all cleared
							}
						last_command_time=time(NULL);
						}
						fprintf(logfile," alarmsensor %d remote %d=%s action %s\n",serial,irm,remotes_labels[irm],lockunlock?"garaz ARM":"garaz DISARM");
						armdisarm_notify(logfile,timestamp,serial,irm,remote_actions_notify_email[serial],remote_actions_notify_sms[serial],lockunlock?"garaz ARM":"garaz DISARM");
						}
						break;
					case UNLOCK_REPORT:
					case LOCK_REPORT: 
						{
						int lockunlock = ((c.cmd.instr&0x0f)==LOCK_REPORT) ? 1 :0;
						fprintf(logfile," lock serial %d action %s due to password %d typed on keyboard %d (suffix %d)\n",serial,lockunlock?"LOCK":"UNLOCK",c.cmd.arg2&0xff,c.cmd.arg2>>8,c.cmd.arg1);
						lock_notify(logfile,timestamp,serial,lockunlock,c.cmd.arg2&0xff,c.cmd.arg2>>8,c.cmd.arg1);
						}
						break;
					case STATUS_REPORT:
						fprintf(logfile," lock serial %d is_locked %d is_armed %d\n",serial,c.cmd.arg1,c.cmd.arg2);
						break;
					case VOLTAGE_REPORT:
						fprintf(logfile," sensor %d voltage is %d\n",serial,c.cmd.arg2); fflush(logfile);
		                                power_notify(logfile,timestamp,c.cmd.arg2,"Garaz");
						break;
					default:
                                                fprintf(logfile,"unknown alarmsensor code %02x\n",c.cmd.instr&0x0f);
                                                return 205;
						break;
                                }
				break;
			default:
				fprintf(logfile,"unknown wireless sensor %02x\n",c.cmd.instr);
				return 202;
		}
			}
		break;
        case ACTOR_DEVICE:
		fprintf(logfile,"unexpected event: wireless actors should not transmit\n"); return 200;
                break;
	default: 
		fprintf(logfile,"unknown wireless device %d\n",device); return 300;
		break;
	}
return 0;
}




void notify(FILE *logfile,int okruh, int stav, char *timestamp, int email, int sms)
{
if(email>=0)
        {
        char command[256];
        sprintf(command,MAILCOMMAND " -s NOTIFY %s",emails[email]);
        FILE *p;
        p=popen(command,"w");
        if(!p) fprintf(logfile,"Error sending e-mail %s\n",emails[email]);
	else
		{
        	fprintf(p,"%s NOTIFY %s : %s %s\n",STRLOCATION,timestamp,alarm_assignment[okruh],alarm_status[stav]);
        	pclose(p);
		}
        }

if(sms>=0)
	{
        char command[256];
        sprintf(command,"S %s %s NOTIFY %s : %s %s\n",smss[sms],STRLOCATION,timestamp,alarm_assignment[okruh],alarm_status[stav]);
        write(smsfifodescr,command,strlen(command));
	}

}


//check whether a given line from an untrusted source has a legal format
int checkRline(char *line)
{
int i;
if(strncmp(line,"R: ",3)) return 0;
if(!isxdigit(line[3]) || !isxdigit(line[4]) || line[5]!=' ' ) return 0;
int len;
if(1!=sscanf(line+3,"%x",&len)) return 0;
//adjust len from bits to nibbles
len += 3; len /= 4;
for(i=6; i<6+len; ++i) if(!isxdigit(line[i])) return 0; 
line[6+32]=0;
return 1;
}


FILE *reopenlogfile(const char *name0, FILE *oldlog)
{
char name[256];
    time_t t;
    struct tm *tmp;
    t = time(NULL);
    tmp = localtime(&t);
sprintf(name,"%s_%d.%02d.%02d",name0,tmp->tm_year+1900,tmp->tm_mon+1,tmp->tm_mday);
FILE *f=fopen(name,"a");
if(f)
	{
	struct passwd *pwd = getpwnam("alarm");
	struct group *grp = getgrnam("alarm");
	chown(name,pwd->pw_uid,grp->gr_gid);
	chmod(name,0640);
	if(oldlog) fclose(oldlog);
	unlink("/usr/local/alarm/alarm.log");
	symlink(name,"/usr/local/alarm/alarm.log");
	return f;
	}
else
	{
	if(oldlog) return oldlog;
	xerror("cannot open logfile");	
	}
}

void forward_packet(char *line, FILE *log, char *timestamp)
{
	struct sockaddr_in udp_target;
	bzero(&udp_target,sizeof(udp_target));
	udp_target.sin_family=AF_INET;
	udp_target.sin_addr.s_addr=FORWARD_IP;
	udp_target.sin_port=htons(FORWARD_PORT);

int len0=strlen(line);
int r;
line[len0]='\n'; line[len0+1]=0;
if(forward_udp_descr>0) r=sendto(forward_udp_descr,line,len0+2,MSG_DONTWAIT,&udp_target,sizeof(udp_target));
line[len0]=0;
if(r!=len0+2) fprintf(log,"%s forward_packet failed with error: %s\n",timestamp,strerror(errno)); fflush(log);
}


main(int argc, char **argv)
{
{
union {int i; char z[sizeof(int)];} u;
u.i=1;
islittleendian= u.z[0];
}
char logfilename[128]="/usr/local/alarm/log/alarm.log";
char fifofile[128]="/usr/local/alarm/fifo";
char smsfifofile[128]="/usr/local/alarm/smsfifo_in";
char smsfifofileout[128]="/usr/local/alarm/smsfifo_out";
char emailfifofile[128]="/usr/local/alarm/emailfifo";
#ifndef emulate
#ifdef CRIS
char device[64]="/dev/ttyS2";
#endif
#ifdef G20
char device[64]="/dev/ttyS3";
#endif
#ifdef RPI
char device[64]="/dev/ttyAMA0";
#endif
#else
char device[64]="/usr/local/alarm/inputfifo";
#endif
char baud[16]="115200";
speed_t baudrate=B115200;


//check if we are already running
{
FILE *pf=fopen("/usr/local/alarm/alarmserver.pid","r");
if(pf)
	{
	pid_t oldpid;
	if(1==fscanf(pf,"%d",&oldpid))
		{
		if(kill(oldpid,0)==0)
			{
			fprintf(stderr,"It seems that alarmserver is already running.\n Check ps and possibly remove alarmserver.pid\n");
			exit(10);
			}
		}
	fclose(pf);
	}
}



read_counters();
read_circuits();
read_rain();

FILE *l;

{
int it;
for(it=0; it<NSENSORS; ++it)
	{
	tempmin[it]=10000;
	tempmax[it]= -10000;
	tempsum[it]=0;
	tempcount[it]=0;
	}
}

while((--argc>0)&&((*++argv)[0]=='-')){
 if (argc==0) usage();
 switch ((*argv)[1]){
  case 'D': ++argv; --argc; strcpy(device,*argv); break;
  case 'L': ++argv; --argc; strcpy(logfilename,*argv); break;
  case 'F': ++argv; --argc; strcpy(fifofile,*argv); break;
  case 'B': strcpy(baud,(*argv)+2); 
	if(!strcmp(baud,"2400")) baudrate=B2400;
	if(!strcmp(baud,"4800")) baudrate=B4800;
	if(!strcmp(baud,"9600")) baudrate=B9600;
	if(!strcmp(baud,"19200")) baudrate=B19200;
	if(!strcmp(baud,"38400")) baudrate=B38400;
	if(!strcmp(baud,"57600")) baudrate=B57600;
	if(!strcmp(baud,"115200")) baudrate=B115200;
	if(!strcmp(baud,"230400")) baudrate=B230400;
	if(baudrate==B0) xerror("unsupported baudrate");
	break;
  default : xerror("unknown option,; use option -H for information");
  }
}
if(argc !=0) xerror("wrong command line; use option -H for information");

#ifdef CRIS
putenv("TZ=CET");
putenv("TZDIR=/usr/local/etc/zoneinfo");
#endif

//start duty counters
heatcool_timestamp=time(NULL);


//open logfile
l=reopenlogfile(logfilename,NULL);

        {
        time_t t;
        struct tm *tmp;
        t = time(NULL);
        tmp = localtime(&t);
        char timestamp[64];
        strftime(timestamp,64,"%c %Z",tmp);
        fprintf(l,"\n%s Start Alarmserver\n",timestamp);
	fflush(l);
	}

atmel_reset();

//change uid to alarm
#ifndef emulate
struct passwd *pwd = getpwnam("alarm");
if(chown(device,pwd->pw_uid,pwd->pw_gid)) {perror("cannot chown ttyS"); exit(10);}
if(setgid(pwd->pw_gid)) {perror("cannot setgid to alarm"); exit(10);}
if(setuid(pwd->pw_uid)) {perror("cannot setuid to alarm"); exit(10);}
#endif

chdir("/usr/local/alarm");
daemon(1,0);
//for debugging
{
chdir("/usr/local/alarm");
prctl(PR_SET_DUMPABLE,1);
struct rlimit rlim;
rlim.rlim_cur = RLIM_INFINITY;
rlim.rlim_max = RLIM_INFINITY;
setrlimit(RLIMIT_CORE, &rlim);
}

int f_fifo=open(fifofile, O_RDWR+O_SYNC+O_NOCTTY,0);
if(f_fifo<0) {fprintf(l,"cannot open connection to fifo\n"); exit(10); }

int f_sms=open(smsfifofile, O_RDWR+O_SYNC+O_NOCTTY); //actually it is RDONLY but mysteriously it makes troubles
if(f_sms<0) {fprintf(l,"cannot open connection to smsserver\n"); exit(10); }

int f_sms_out=open(smsfifofileout, O_RDWR+O_SYNC+O_NOCTTY,0); //actually is wronly
if(f_sms_out<0) {fprintf(l,"cannot open connection 2 to smsserver\n"); exit(10); }
smsfifodescr = f_sms_out;

write(f_sms_out,"R\n",2); //reset phone at smsserver

int f_email=open(emailfifofile, O_RDWR+O_SYNC+O_NOCTTY,0);
if(f_email<0) {fprintf(l,"cannot open connection to emailserver\n"); exit(10); }

//initialize incoming UDP
int f_udp = socket(AF_INET, SOCK_DGRAM, 0);
if(f_udp<0) {fprintf(l,"cannot open UDP socket\n"); exit(10); }
socklen_t udp_fromlen;
struct sockaddr_in udp_server;
struct sockaddr_in udp_from;
{
int length  = sizeof(udp_server);
bzero(&udp_server,length);
udp_server.sin_family=AF_INET;
udp_server.sin_addr.s_addr=INADDR_ANY;
udp_server.sin_port=htons(ALARMSERVER_UDP);
if (bind(f_udp,(struct sockaddr *)&udp_server,length)<0)
	{fprintf(l,"cannot bind incoming UDP socket\n"); exit(10); }
udp_fromlen = sizeof(struct sockaddr_in);
fcntl(f_udp,F_SETFL,O_NONBLOCK);
}

//initialize outgoing UDP
if(udp_forward)
	{
	forward_udp_descr =   socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if(forward_udp_descr<0) {fprintf(l,"cannot open UDP socket\n"); exit(10); }
	//fcntl(forward_udp_descr,F_SETFL,O_NONBLOCK);	
	}

int f=open(device,O_RDWR|O_NOCTTY|O_EXCL|O_NONBLOCK,0);
if(f<0) {fprintf(l,"cannot open connection to alarm: %s\n",strerror(errno)); exit(10); }

struct termios devicetermios, ttytermios;
filehandle=f;
if(tcgetattr(f,&devicetermios)) perror("cannot tcgetattr 1");
memcpy(&devicetermios0,&devicetermios,sizeof(struct termios));
cfsetispeed(&devicetermios,baudrate); cfsetospeed(&devicetermios,baudrate);
devicetermios.c_iflag |= IGNBRK;
devicetermios.c_iflag &= ~BRKINT;
devicetermios.c_iflag &= ~ICRNL;
devicetermios.c_iflag &= ~IMAXBEL;
devicetermios.c_iflag &= ~IXON;
devicetermios.c_iflag &= ~IXOFF;
devicetermios.c_oflag &= ~OPOST;
devicetermios.c_oflag &= ~ONLCR;
devicetermios.c_cflag |= CLOCAL;
devicetermios.c_cflag &= ~CRTSCTS;
devicetermios.c_lflag &= ~ISIG;
devicetermios.c_lflag &= ~ICANON;
devicetermios.c_lflag &= ~IEXTEN;
devicetermios.c_lflag &= ~ECHO;
devicetermios.c_lflag &= ~ECHOE;
devicetermios.c_lflag &= ~ECHOK;
devicetermios.c_lflag &= ~ECHOCTL;
devicetermios.c_lflag &= ~ECHOKE;
cfmakeraw(&devicetermios);
if(tcsetattr(f,TCSANOW,&devicetermios)) perror("cannot tcsetattr 1");


char oldline[MAXLINE]="";
char old2line[MAXLINE]="";

//e-mail and sms notify user 0 about reset
        {
        time_t t;
        struct tm *tmp;
        t = time(NULL);
        tmp = localtime(&t);
        char timestamp[64];
        strftime(timestamp,64,"%c %Z",tmp);
	reset_notify(l,timestamp,0,0);
	}

//at startup zero out all sensors - the watching becomes active only once at least one message is received
{
int i;
for(i=0; i<NSENSORS; ++i)
	wireless_sensor_ping_last[i] = 0;
}
udp_last = 0;

//create a pidfile
{
FILE *pf=fopen("/usr/local/alarm/alarmserver.pid","w");
if(!pf) {fprintf(l,"cannot create/write /usr/local/alarm/alarmserver.pid"); exit(10);}
fprintf(pf,"%d\n",getpid());
fclose(pf);
}

int report_sent=0;
int logfile_reopened=1;

last_rain_time[0] = last2_rain_time[0] = time(NULL);

//MAIN LOOP
int rr=0; int rr_sms=0; int rr_fifo=0; int rr_email=0; int rr_udp=0;
while(1)
{
int savecounters=0;
savecircuits=0;

char line[MAXLINE];
char linework[MAXLINE];
char line_fifo[MAXLINE];
char line_sms[MAXLINE];
char line_email[MAXLINE];
char line_udp[MAXLINE];

//select and read line
char *p=line;
char *p_fifo=line_fifo;
char *p_sms=line_sms;
char *p_email=line_email;
char *p_udp=line_udp;
char *x=NULL;
char *x_fifo=NULL;
char *x_sms=NULL;
char *x_email=NULL;
char *x_udp=NULL;

int alarm_input=0; int fifo_input=0; int sms_input=0; int email_input=0; int udp_input=0;
char udp_source[32];

time_t t; struct tm *tmp; char timestamp[64];

//accumulate lines from each input source
do{
fd_set readfds;
fd_set writefds;
fd_set exceptfds;
int r,s;
FD_ZERO(&writefds);
FD_ZERO(&exceptfds);
FD_ZERO(&readfds);
FD_SET(f,&readfds);
FD_SET(f_fifo,&readfds);
FD_SET(f_sms,&readfds);
FD_SET(f_email,&readfds);
FD_SET(f_udp,&readfds);
int maxf=f;
if(f_fifo>f) maxf=f_fifo;
if(f_sms>f) maxf=f_sms;
if(f_sms_out>f) maxf=f_sms_out;
if(f_email>f) maxf=f_email;
if(f_udp>f) maxf=f_email;

struct timeval timeout;
timeout.tv_sec=10; //time resolution for ping and delayed alarm
timeout.tv_usec=0;

if((s=select(maxf+1,&readfds,&writefds,&exceptfds,&timeout)) == -1) {fprintf(l,"select error\n"); perror("select"); exit(10);}

if(FD_ISSET(f,&readfds)) //accomodate for multiple lines in buffer - read only one at a time (atmel generates output fast)
                {
		x=NULL;
		while((p-line) < MAXLINE-1)
			{
			r=read(f,p,1); 
			if(r!=1) break;
			rr+=1;
			p+=1;
			if(p[-1] == '\n' || p[-1] == '\r') 
				{
				x=p-1;
				break;		
				}
			}
		alarm_input= x || rr>=MAXLINE-1;
		}

if(FD_ISSET(f_fifo,&readfds)) //assume single line available at a time
                {
                rr_fifo+=r=read(f_fifo,p_fifo,MAXLINE-1-(p_fifo-line_fifo));
                p_fifo+=r;
                x_fifo=strchr(line_fifo,'\n');
                if(!x_fifo) x_fifo=strchr(line_fifo,'\r');
                fifo_input= x_fifo || rr_fifo>=MAXLINE-1;
		}

if(FD_ISSET(f_sms,&readfds)) //assume single line available at a time
                {
                rr_sms+=r=read(f_sms,p_sms,MAXLINE-1-(p_sms-line_sms));
                p_sms+=r;
                x_sms=strchr(line_sms,'\n');
                if(!x_sms) x_sms=strchr(line_sms,'\r');
                sms_input= x_sms || rr_sms>=MAXLINE-1;
		}

if(FD_ISSET(f_email,&readfds)) //assume single line available at a time
                {
                rr_email+=r=read(f_email,p_email,MAXLINE-1-(p_email-line_email));
                p_email+=r;
                x_email=strchr(line_email,'\n');
                if(!x_email) x_email=strchr(line_email,'\r');
                email_input= x_email || rr_email>=MAXLINE-1;
                }

if(FD_ISSET(f_udp,&readfds)) //assume single line available at a time
                {
		r=recvfrom(f_udp,p_udp,MAXLINE-1-(p_udp-line_udp),0,(struct sockaddr *)&udp_from,&udp_fromlen);
		unsigned long saddr=ntohl(udp_from.sin_addr.s_addr);
		sprintf(udp_source,"%d.%d.%d.%d",((saddr>>24)&0xff),((saddr>>16)&0xff),((saddr>>8)&0xff),(saddr&0xff));
		//@@@check the source, optionally whitelist IPs
		if(r<=0)  goto skip_udp;
                rr_udp+=r;
                p_udp+=r;
                x_udp=strchr(line_udp,'\n');
                if(!x_udp) x_udp=strchr(line_udp,'\r');
                udp_input= x_udp || rr_udp>=MAXLINE-1;
		udp_last = time(NULL);
                }
skip_udp:

t = time(NULL);
tmp = localtime(&t);
isday = ( tmp->tm_hour > DAY_HOUR && tmp->tm_hour < NIGHT_HOUR );
strftime(timestamp,64,"%c %Z",tmp);

//check the UDP is not stalled
if(udp_last && t-udp_last  > 3600)
	{
	int stav,okruh;
	stav = ALARM_NOPING;
	okruh = OKRUH_GARAZ_VIRT;
	report_alarm(l,okruh,stav,timestamp,"UDP PACKETS LOST",1);
	udp_last = 0; //prevent repeated messages
	}


//check regularly whether ping time of some sensor has been exceeded
{
int i;
for(i=0; i<NSENSORS; ++i)
	if(wireless_sensor_ping_timeouts[i] && wireless_sensor_ping_last[i])
		{
		if(t-wireless_sensor_ping_last[i] > wireless_sensor_ping_timeouts[i])
			{
			int stav,okruh;
			fprintf(l,"%s LOST PING CONTACT with sensor %d\n",timestamp,i); fflush(l);
			stav = ALARM_NOPING;
                        okruh = wireless_ping_okruh[i]; //formal circuit where to report no ping
                        if(okruh >=0 && okruh <N_CIRCUITS) 
				{
				savecircuits = 1;
				//do not care whether it has been active - it must always ping
				circuits_alarm[okruh]=1;
                                report_alarm(l,okruh,stav,timestamp,"NO PING",1);
				//DO NOT use sirenes for this alarm (yet?) - false alarms!
				}
			wireless_sensor_ping_last[i]=0; //prevent repeated messages
			}
		}
}

//check for delayed alarms
{
int i;

for(i=0; i<N_CIRCUITS; ++i)
	{
	if(circuits_status[i])
		{
		if(circuits_delayed_alarm[i]!=0 && t > circuits_delayed_alarm[i] && !circuits_alarm[i])
			{
                        savecircuits=1;
                        fprintf(l,"DELAYED ALARM circuit %d!",i); fflush(l);
                        circuits_alarm[i]=1;
                        report_alarm(l,i,4,timestamp,NULL,0);
			sirenes_on(i);
			circuits_delayed_alarm[i]=0;
			}
		}
	else 	//has been unblocked in the meantime
		{
		circuits_delayed_alarm[i]=0;
		}
	}
}

} while(!fifo_input && !alarm_input && !sms_input && !email_input && !udp_input); 


int okruh,stav,issensor;
char *packet_source;

//log to a file with a timestamp and make further processing if appropriate
if(alarm_input)
	{
	rr=0;
	if(x) x[0]=0;
	strncpy(linework,line,MAXLINE);linework[MAXLINE-1]=0;
	switch(linework[0])
		{
		//@@@Reset! message comes here - confusing?!
		case 'R': //screen from repeated messages
			packet_source="wireless"; //433 wireless
			process_R:
			savecounters=1;
			if(strcmp(linework,oldline) && strcmp(linework,old2line))
				{
				fprintf(l,"%s %s ",timestamp,linework); fflush(l);
				strcpy(old2line,oldline);
				strcpy(oldline,linework);
				int i;
				if(strcmp(packet_source,"wireless")==0)
					 for(i=0; i<udp_forward; ++i) forward_packet(linework,l,timestamp);

				//try to decrypt the wireless packet and interpret it
				issensor=0;
				if(process_packet(packet_source,l,timestamp,linework,&okruh,&stav,&issensor) == 0 && issensor) goto virtual_A;
				}
			break;
		case 'K': //note about registered Keeloq remote button press
                        {
                        int ret,serial,buttons;
                        if(3!=sscanf(linework+2,"%d %d %d",&ret,&serial,&buttons)) {fprintf(l,"ERROR parsing %s\n",linework); fflush(l); break;}
                        fprintf(l,"%s Remote %d button %d pressed\n",timestamp,serial,buttons);
                        }
                        break;
		case 'A': //check whether a given circuit is active and make alarm if so
			if(2!=sscanf(linework+2,"%d = %d",&okruh,&stav)) {fprintf(l,"ERROR parsing %s\n",linework); fflush(l); break;}
			virtual_A:
			fprintf(l,"%s %s %s ",timestamp,alarm_assignment[okruh],alarm_status[stav]); fflush(l);
			switch(stav) {
				case 1: break; //klid
				case 2: //conditional alarm
				case 3: //conditional alarm
					{
					time_t tt=time(NULL);
					if(!circuits_status[okruh]) break; //not active			
					if((circuits_status[okruh]&2) && tt-last_command_time < circuits_delays[okruh]) break; //delayed activation 
					if(circuits_status[okruh]&2) //delayed deactivation - pipni sirenkou a nastav delayed alarm!
						{
						circuits_delayed_alarm[okruh] = tt + circuits_delays[okruh];
						if(circuits_delays[okruh]>=30) write(f,"s 10\n",5); //notify the user by a short beep
						break;
						}
					if(okruh == FIRE_CIRCUIT) //check also for increased temperature to avoid false triggering - fire alarm should be taken seriously
						{
						fire_temp_threshold = 400;
						write(f,"t\n",2); //request immediate temperature report; output will be treated in another branch
						break;
						}
					}
					//no break here intentionally
				case 0: //should never happen - unconditional alarm - zkrat
					if(ignorezkrat && stav==0) break;
					savecircuits=1;
					if(circuits_alarm[okruh]) break;
					//make alarm only if not already done for this circuit
					fprintf(l,"ALARM!"); fflush(l);
					circuits_alarm[okruh]=1;
					report_alarm(l,okruh,stav,timestamp,NULL,0);
					sirenes_on(okruh);
					break;
				}
			//process notifications
			if(circuits_notify[okruh]) //&& stav!=1
				{
				notify(l,okruh,stav,timestamp,circuits_notify_email[okruh], -1);

				if((circuits_notify[okruh] & 2) == 0) circuits_notify[okruh]=0; //one-shot notify
				}
			fprintf(l,"\n");fflush(l);
			break;
		case 'B': //alarm directly triggered by the low level processor
			if(2!=sscanf(linework+2,"%d = %d",&okruh,&stav)) {fprintf(l,"ERROR parsing %s\n",linework); fflush(l); break;}
			fprintf(l,"%s %s %s\n",timestamp,alarm_assignment[okruh],stav?"alarm ON":"alarm OFF"); fflush(l);
			if(okruh<0||okruh>=N_CIRCUITS) break;
			savecircuits=1;
			circuits_alarm[okruh]=stav;
			if(stav!=0)
				{
				report_alarm(l,okruh,2,timestamp,NULL,0);
				sirenes_on(okruh);
				}
			if(circuits_notify[okruh]) 
                                {
                                notify(l,okruh,stav+1,timestamp,circuits_notify_email[okruh], -1);

                                if((circuits_notify[okruh] & 2) == 0) circuits_notify[okruh]=0; //one-shot notify
                                }
			break;
		case 'C': //change of circuit status notification triggered by the low level processor
			{
			if(2!=sscanf(linework+2,"%d = %d",&okruh,&stav)) {fprintf(l,"ERROR parsing %s\n",linework); fflush(l); break;}
                        fprintf(l,"%s %s %s\n",timestamp,alarm_assignment[okruh],stav?"ARM":"DISARM"); fflush(l);

			if(okruh<0||okruh>=N_CIRCUITS) break;
			if(stav)
				circuits_status[okruh]=stav;
			else
				{
				circuits_alarm[okruh]=0;
				circuits_status[okruh]=0;
				sirenes_off();
				}
			savecircuits=1;
			if(circuits_notify[okruh]) //&& stav!=1
                                {
                                notify(l,okruh,stav,timestamp,circuits_notify_email[okruh], -1);

                                if((circuits_notify[okruh] & 2) == 0) circuits_notify[okruh]=0; //one-shot notify
                                }
			fprintf(l,"\n");fflush(l);
			}
			break;
		case 'P': //power status 
			{
			int onoff=2;
			if(strstr(linework,"AC ON")) onoff=1;
			if(strstr(linework,"AC OFF")) onoff=0;
			if(onoff==2)
				{
				fprintf(l,"%s AC power message: %s\n",timestamp,linework);
				}
			else
				{
				fprintf(l,"%s AC POWER CHANGED TO %d\n",timestamp,onoff); fflush(l);
				power_notify(l,timestamp,onoff,STRLOCATION);
				}
			}
			break;
		case 't': //local temperature
			{
			int t,t2,r;
			r=sscanf(linework+3,"%d %d",&t,&t2);
			if(r==1) t2=t;
			if(r>0)
				{
				fprintf(l,"%s Local Temperature T = %d (%d)\n",timestamp,t,t2); fflush(l);
                        	FILE *f=fopen("/usr/local/alarm/temperature_X","w");
                        	if(f)
                               	 	{
                               	 	fprintf(f,"%.1f",t/10.);
                               	 	fclose(f);
                                	}
				if(t>fire_temp_threshold) //fire alarm based on temperature over 50 degres alone
					{
					if(!circuits_alarm[FIRE_CIRCUIT])
			                        {
            			                savecircuits=1;
           			                if(fire_temp_threshold<FIRE_TEMP_THRESHOLD) fprintf(l,"SENSOR+TEMPERATURE-BASED FIRE ALARM!\n");
						else fprintf(l,"TEMPERATURE-BASED FIRE ALARM!\n"); 
						fflush(l);
               			                circuits_alarm[FIRE_CIRCUIT]=1;
                			        report_alarm(l,FIRE_CIRCUIT,6,timestamp,fire_temp_threshold<FIRE_TEMP_THRESHOLD?"Fire! Active sensor + High temperature!" : "Fire! High temperature!",0);
                 			        sirenes_on(FIRE_CIRCUIT);
                        			}

					}
				}
			}
			break;
		case 0:
			break; //silently ignore empty lines
		default:
			fprintf(l,"%s Unprocessed comment: %s\n",timestamp,linework); fflush(l);
			break;
		}
	fflush(l);
	alarm_input=0;
	}


if(sms_input) //@@@implement some additional primitive authentization, like a password, or better some encryption of the whole SMS
	{
	rr_sms=0;
	if(x_sms) x_sms[0]=0;
	int offset;
	char source[MAXLINE];

	sms_notify(l,timestamp,0,line_sms);

	if(1!=sscanf(line_sms,"%256s %n",source,&offset))
		{
		fprintf(l,"%s MALFORMED INCOMING SMS: %s\n",timestamp,line_sms);
		}	
	else 
		{
		fprintf(l,"%s SMS COMMAND from %s : %s\n",timestamp,source,line_sms+offset); fflush(l);
		switch(line_sms[offset])
		{
//switch off until security mechanism is implemented
#if 0
		case 'T': 
			if(strncmp(line_sms+offset+2,"TEMPSET",7)) 
				{
				char rawcode[64];
				CODE433 c;
				int serial=0;
				int command=SET_TEMPERATURE;
				int argument;
				if(1!=sscanf(line_sms+offset+2+8,"%d",&argument)) break;
				c.cmd.instr=THERMOSTAT|command;
				c.cmd.arg1=0;
				c.cmd.arg2=argument;
				uint8_t s=prepare_packet(l,timestamp,rawcode,ACTOR_DEVICE,serial,c.code,5);
				savecounters=1;
				write(filehandle,&rawcode,s);
                                write(filehandle,"\n",1);
				}
			break;
		case 'X':
			if(strncmp(line_sms+offset+2,"DSLRESET",8)) write(filehandle,"pd\n",3);
			if(strncmp(line_sms+offset+2,"PBXRESET",8)) write(filehandle,"pi\n",3);
			if(strncmp(line_sms+offset+2,"ETHRESET",8)) write(filehandle,"ps\n",3);
			if(strncmp(line_sms+offset+2,"FOXRESET",8)) write(filehandle,"pf\n",3);
			if(strncmp(line_sms+offset+2,"AVRRESET",8)) atmel_reset();
			break;
#endif
		case 'R': //virtual 433 receive - this is an encrypted packet
			strncpy(linework,line_sms+offset,MAXLINE);linework[MAXLINE-1]=0;
			if(checkRline(linework)) {sms_input=0; packet_source="sms"; goto process_R;}
			//no break
		default:
			fprintf(l,"%s ILLEGAL SMS COMMAND from %s : %s\n",timestamp,source,line_sms+offset); fflush(l);
			break;
		}
		}
	sms_input=0;
	}

if(email_input)
        {
        rr_email=0;
        if(x_email) x_email[0]=0;
	int offset;
	char source[MAXLINE];
	if(1!=sscanf(line_email,"%256s %n",source,&offset))
		{
		fprintf(l,"%s MALFORMED INCOMING email: %s\n",timestamp,line_email);
		}	
	else switch(line_email[offset])
		{
		case 'R':
			fprintf(l,"%s email COMMAND from %s : %s\n",timestamp,source,line_email+offset); fflush(l);
			strncpy(linework,line_email+offset,MAXLINE);linework[MAXLINE-1]=0;
			if(checkRline(linework)) {email_input=0; packet_source="email"; goto process_R;}
			//no break
		default:
			fprintf(l,"%s ILLEGAL email COMMAND from %s : %s\n",timestamp,source,line_email+offset); fflush(l);
			break;
		}
	email_input=0;
        }


if(udp_input)
        {
        rr_udp=0;
        if(x_udp) x_udp[0]=0;
	fprintf(l,"%s UDP packet received from %s: %s\n",timestamp,udp_source,line_udp); fflush(l);
	udp_input=0;
	strncpy(linework,line_udp,MAXLINE);linework[MAXLINE-1]=0;
	if(checkRline(linework)) {packet_source=udp_source; goto process_R;}
        }


if(fifo_input) 
	{
	rr_fifo=0;
	if(x_fifo) x_fifo[0]=0;
	fprintf(l,"%s Command from FIFO: %s\n",timestamp,line_fifo); fflush(l);
	switch(line_fifo[0]) //processing commands from named pipe
		{
		case 'i': //ignore zkrat 
			{
			ignorezkrat = line_fifo[1]-'0';
			fprintf(l,"%s Ignorezkrat has been set to %d\n",timestamp,ignorezkrat); fflush(l);
			}
			break;
		case 'c': //set circuits status
			{
			int okruh,status,alarm;
			if(3 != sscanf(line_fifo,"c %d %d %d",&okruh,&status,&alarm)) break;
			if(okruh<0||okruh>=N_CIRCUITS) break;
			circuits_status[okruh] = status;
			circuits_alarm[okruh] = alarm;	
			camera_was_sent[camera_assignment[okruh]]=0;
			savecircuits=1;
			}
			break;
		case 'l': //log the current status of circuits
			{
			int i;
			for(i=0; i<N_CIRCUITS; ++i)
				fprintf(l,"%s Status of %s: %s %s\n",timestamp,alarm_assignment[i],circuits_status[i]?"armed":"disarmed", circuits_alarm[i]?"alarm":"ok");
			fflush(l);
			}
			break;
		case 'F': //forward a command to atmel
			write(f,line_fifo+1,strlen(line_fifo+1));
                        write(f,"\n",1);
			break;
		case 'f': //forward this to smsserver
			write(f_sms_out,line_fifo+1,strlen(line_fifo+1));
			write(f_sms_out,"\n",1);
			break;
		case 'L': //list keeloq counters
		case 'C': //set keeloq counters (after reprogramming of some device)
			{
			unsigned int s,c,i;
			switch(line_fifo[1]) {
				case 'r':
				case 'R':
					if(line_fifo[0]=='C') {if(2==sscanf(line_fifo+2,"%d %d",&s,&c)) if(s<N_REMOTE(ALARM)) {remotes[s].counter=c; remote_resyncs[s]=0;}}
                                        else {for(i=0; i<N_REMOTE(ALARM); ++i) fprintf(l,"%s: remote counter [%d] = %d\n",timestamp,i,remotes[i].counter); fflush(l);}
					break;
				case 'a':
				case 'A': 
					if(line_fifo[0]=='C') {if(2==sscanf(line_fifo+2,"%d %d",&s,&c)) if(s<NACTORS) {actor_counters[s]=c; actor_resyncs[s]=0;}}
					else {for(i=0; i<NACTORS; ++i) fprintf(l,"%s: actor counter [%d] = %d\n",timestamp,i,actor_counters[i]); fflush(l);}
					break;
				case 's':
				case 'S': 
					if(line_fifo[0]=='C') {if(2==sscanf(line_fifo+2,"%d %d",&s,&c)) if(s<NSENSORS) {sensor_counters[s]=c; sensor_resyncs[s]=0;}}
					else {for(i=0; i<NSENSORS; ++i) fprintf(l,"%s: sensor counter [%d] = %d\n",timestamp,i,sensor_counters[i]); fflush(l);}
					break;
				case 'k':
				case 'K':
					if(line_fifo[0]=='C') {if(2==sscanf(line_fifo+2,"%d %d",&s,&c)) if(s<NKEYBOARDS) {keyboard_counters[s]=c; keyboard_resyncs[s]=0;}}
					else {for(i=0; i<NKEYBOARDS; ++i) fprintf(l,"%s: keyboard counter [%d] = %d\n",timestamp,i,keyboard_counters[i]); fflush(l);}
					break;
				default:
					break;
				}
			savecounters=1;
			}
			break;
		case 't':
		case 'T': //generate packet for a transmission of a command to a wireless peripheral
			switch(line_fifo[1]) {
				case 'G': //general
					{
					char rawcode[64];
                                        CODE433 c;
                                        int serial,command,argument, arg2;
                                        if(4!=sscanf(line_fifo+2,"%d %d %d %d",&serial,&command,&argument,&arg2)) break;
                                        c.cmd.instr=command;
                                        c.cmd.arg1=argument&0xff;
                                        c.cmd.arg2=arg2;
                                        uint8_t s;
                                        s=prepare_packet(l,timestamp,rawcode,ACTOR_DEVICE,serial,c.code,5);
                                        savecounters=1;
                                        write(f,&rawcode,s);
                                        write(f,"\n",1);
					}
					break;
				case 'R': //relay
					{
					char rawcode[64];
                                        CODE433 c;
                                        int serial,command,argument;
                                        if(3!=sscanf(line_fifo+2,"%d %d %d",&serial,&command,&argument)) break;
                                        c.cmd.instr=RELAY|command;
					c.cmd.arg1=argument&0xff;
					c.cmd.arg2=argument>>8;
					uint8_t s;
                                        s=prepare_packet(l,timestamp,rawcode,ACTOR_DEVICE,serial,c.code,5);
                                        savecounters=1;
                                        write(f,&rawcode,s);
                                        write(f,"\n",1);
					}
					break;
				case 'T': //thermostat
					{
					char rawcode[64];
					CODE433 c;
					int serial,command,argument,arg2;
					arg2=0;
					if(3>sscanf(line_fifo+2,"%d %d %d %d",&serial,&command,&argument,&arg2)) break;
					c.cmd.instr=THERMOSTAT|command;
					switch(command) {
						case LOCK_TEMPSET:
						case SET_REGIME:
						case SET_HYSTON:
						case SET_HYSTOFF:
						case HEATCOOL_CTRL:
							c.cmd.arg1=argument;
							break;
						case SET_OUTPUT_COUNTER: //24 bits supported
							c.cmd.arg1=argument>>16;
							c.cmd.arg2=argument&0xffff;
							break;
						case SET_TEMPERATURE:
							c.cmd.arg1=arg2;
							c.cmd.arg2=argument;
							break;
						case GET_STATUS:
						case RESET_HEATER:
							break;
						case SET_EFFECTIVE:
							{
							int arg2,arg3;
							if(2!=sscanf(line_fifo+2,"%*d %*d %*d %d %d",&arg2,&arg3)) break;
							c.cmd.arg2=argument<<8|arg2;
							c.cmd.arg1=arg3;
							}
							break;
						default: goto aborting;
					}
					uint8_t s;
					s=prepare_packet(l,timestamp,rawcode,ACTOR_DEVICE,serial,c.code,5);
					savecounters=1;
					write(f,&rawcode,s);
                                        write(f,"\n",1);
					}
					break;
				case '1': //raw code Tn xx hex
				case '2': //raw code
				case '3': //raw code
				case '4': //raw code
				case '5': //raw code
				case '6': //raw code
				case '7': //raw code
				case '8': //raw code
				case '9': //raw code
					{
					int onlysend=(line_fifo[0]=='t');
					line_fifo[0]='T';
					write(f,line_fifo,strlen(line_fifo));
					write(f,"\n",1);
					if(onlysend) break;
					{
					//also interpret the packet like if it were received - useful for virtual beyboards
					int okruh,stav,issensor=0;
					char linework[64];
					strcpy(linework,line_fifo);
					linework[0]='R';
					linework[1]=':';
					process_packet("internal",l,timestamp,linework,&okruh,&stav,&issensor);
					if(issensor) fprintf(l,"%s interpretation of virtual sensor messages from transmitted messages not implemented\n",timestamp);	
					}
					}
					break;
			}
			aborting:
			break;
		case 'N': //set notify
			{
			int typ,okruh,email,sms;
			char name[32];
			if(4 == sscanf(line_fifo,"N%d %32s %d %d",&typ,&name,&email,&sms))
				{
				int i;
				okruh= -1;
				for(i=0; i<N_CIRCUITS; ++i)
					{
					if(!strcmp(name,alarm_assignment[i]))
						{
						okruh=i;
						break;
						}
					}
				if(okruh>=0 && okruh<N_CIRCUITS)
					{
					circuits_notify[okruh]=typ;
					circuits_notify_email[okruh]=email;
					circuits_notify_sms[okruh]=sms;
					fprintf(l,"%s Notification set %s %d %d %d\n",timestamp,name,typ,email,sms);
					fflush(l);
					}
				}
			}
			break;
		
		default:;
		}
	fifo_input=0;
	}

if(savecounters) {save_counters(); savecounters=0;}
if(saverain) {save_rain(); saverain=0;}
if(savecircuits) 
	{
	save_circuits();
	//change status LED
	if(LED_STATUS_CIRCUIT<0) {write(f,"g0\n",3); write(f,"r0\n",3); write(f,"b0\n",3);}
	else if(circuits_status[LED_STATUS_CIRCUIT]) {write(f,"g0\n",3); write(f,"r1\n",3);} 
	else {write(f,"g1\n",3); write(f,"r0\n",3);}
	savecircuits=0;
	}

//reopen logfile daily
{
time_t t;
struct tm *tmp;
t = time(NULL);
tmp = localtime(&t);
if(tmp->tm_hour==23) logfile_reopened=0;

if(!logfile_reopened && tmp->tm_hour==0)
	{
	//reset phone at smsserver
	write(f_sms_out,"R\n",2);
	//
	l=reopenlogfile(logfilename,l);
	logfile_reopened=1;
	//shift daily rain accumulation
	int i,j;
	for(j=0; j<N_METEO; ++j) 
		{
		for(i=YEAR-1; i>=1; --i) rain_cumulative[j][i] = rain_cumulative[j][i-1];
		rain_cumulative[j][0]=0.;
		}
	saverain=1;

	//reset counter for heaters and coolers duty
	for(i=0; i<NSENSORS; ++i)
		{
		if(heater_started[i])
			{
			heater_ontime[i] += t-heater_started[i]; 
			heater_started[i]=t;
			}
		//if(heater_ontime[i]) //print also zero 
			{
			char name[32];
			sprintf(name,"/usr/local/alarm/heater_%d",i);
                        FILE *f = fopen(name,"w");
                        if(f)
				{
				fprintf(f,"%.3f %.1f %s",heater_ontime[i]/3600.,heater_ontime[i]*100./(t-heatcool_timestamp),heater_started[i]?"ON":"OFF");
				fclose(f);
				}
			heater_ontime[i]=0;
			}

		if(cooler_started[i])
			{
			cooler_ontime[i] += t-cooler_started[i]; 
			cooler_started[i]=t;
			}
		//if(cooler_ontime[i]) //print also zero
			{
			char name[32];
			sprintf(name,"/usr/local/alarm/cooler_%d",i);
                        FILE *f = fopen(name,"w");
                        if(f)
				{
				fprintf(f,"%.3f %.1f %s",cooler_ontime[i]/3600.,cooler_ontime[i]*100./(t-heatcool_timestamp),cooler_started[i]?"ON":"OFF");
				fclose(f);
				}
			cooler_ontime[i]=0;
			}

		}
	heatcool_timestamp=time(NULL);
	}
}

//send a weekly sms message on friday noon to check proper functionality
if(N_SMS>0)
    {
    time_t t;
    struct tm *tmp;
    t = time(NULL);
    tmp = localtime(&t);

    //clear report_sent on satturday
    if(tmp->tm_wday == 6) report_sent=0;


    if(!report_sent && tmp->tm_wday == 5 && tmp->tm_hour >= 12)
	{
	char command[256];
	sprintf(command,"S %s %s Alarm Health Report at %s\n",smss[0],STRLOCATION,timestamp);
	write(smsfifodescr,command,strlen(command));
	report_sent=1;
	}
    }


//test
//report_alarm(l,0,0,timestamp,"JUST A TEST",0); exit(0);

} //MAIN loop

fclose(l);
close(f);
}
